//---------------------------------------------------------------------------------------
// created as RSSCache.h by znek on Sun 29-Oct-2000
// $Id: RSSCache.h,v 1.2 2001/07/27 10:25:36 znek Exp $
//
//  Copyright (c) 2000 by Marcus Mueller <znek@mulle-kybernetik.com>.
//  All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted under the terms of the GNU General Public License, version 2
//  as published by the Free Software Foundation, provided that both the copyright notice
//  and this permission notice appear in all copies of the software, derivative works or
//  modified versions, and any portions thereof, and that both notices appear in supporting
//  documentation, and that credit is given to Marcus Mueller in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  This is free software; you can redistribute and/or modify it under
//  the terms of the GNU General Public License, version 2 as published by the Free
//  Software Foundation. Further information can be found on the project's web pages
//  at http://www.mulle-kybernetik.com/software/MKPortal
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------


#import <Foundation/Foundation.h>


@class RSSParser;
@class RSSDocument;


@interface RSSCache : NSObject
{
    RSSParser *rssParser;
    NSMutableDictionary *rssDocumentLUT;
    NSTimeInterval expireInterval;
}

+ (id)sharedCache;
+ (void)setBundle:(NSBundle *)aBundle;

- (RSSParser *)rssParser;

// Cache management
- (void)setExpireInterval:(NSTimeInterval)anInterval;
- (NSTimeInterval)expireInterval;
- (void)flushCaches;


// High level API.
- (RSSDocument *)documentObjectForURL:(NSString *)urlString;

// Higher level API. Will retrieve Object from cache OR call getDocumentDescriptionFromURL:
// if document isn't found in cache
- (NSDictionary *)documentDescriptionForURL:(NSString *)urlString;

// Will retrieve Object directly from URL
- (NSDictionary *)getDocumentDescriptionFromURL:(NSString *)urlString;

@end

// Keys for the DocumentDescription
extern NSString *RSSDocumentObjectKey;
extern NSString *RSSDocumentKey;
extern NSString *RSSDocumentURLKey;
extern NSString *RSSDocumentErrorKey;
extern NSString *RSSDocumentTimestampKey;
