// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniAIAT/OAITokenizerRegistry.h,v 1.4 1998/02/26 13:29:28 kc Exp $

#import <Foundation/NSObject.h>

@class NSMutableDictionary;

#import "OAITokenizerProtocol.h"

@interface OAITokenizerRegistry : NSObject
{
    NSMutableDictionary *tokenizers;
    NSMutableDictionary *bundleInformation;
    NSMutableDictionary *typeToBundle;
}

+ (OAITokenizerRegistry *)sharedRegistry;

- (void)registerTokenizer:(id <OAITokenizer>)aTokenizer forExtension:(NSString *)extension;

- (BOOL)hasTokenizerForExtension:(NSString *)extension;
- (void *)tokenizerForExtension:(NSString *)extension withStream:(void *)stream;

@end
