// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniAIAT/OAIObjCTokenizer.h,v 1.2 1998/02/26 13:29:27 kc Exp $

#import <AIAT/IAAnalysis.h>

extern "C" {
    #import <Foundation/NSObject.h>
    #import "OAITokenizerProtocol.h"
    #import <OmniFoundation/OFStringScanner.h>
}

class OAIObjCTokenizer : public IATokenStream {
public:
    OAIObjCTokenizer(id <OAITokenizerInstance> objCObject, OFStringScanner *scanner);
    ~OAIObjCTokenizer();

    IAToken *GetNextToken();
    void GetTextSpan(byte *dest, uint32 startPos, uint32 endPos);

private:
    id <OAITokenizerInstance> tokenizer;
    OFStringScanner *scanner;
};
