// Copyright 1998 Omni Development, Inc.  All rights reserved.

extern "C" {
    #import "OAIIndex.h"
}

#import <Foundation/Foundation.h>
#import <AIAT/UFSStorage.h>
#import <AIAT/InvertedIndex.h>
#import <AIAT/InvertedAccessor.h>
#import <AIAT/UFSDirectoryCorpus.h>
#import <AIAT/SimpleAnalysis.h>
#import <AIAT/IAAccessor.h>
#import <AIAT/IACorpus.h>
#import <OmniBase/rcsid.h>

#import "OAICorpus.h"

RCS_ID("$Header: /LocalDeveloper/Source/CVS/OmniGroup/OmniAIAT/OAIIndex.M,v 1.2 1998/02/25 10:56:24 kc Exp $")

@implementation OAIIndex

// Init and dealloc

- initNewIndex:(NSString *)filename forDirectory:(NSString *)directory;
{
    if (![super init])
        return nil;

    storage = MakeFileStorage([filename cString]);
    ((IAStorage *)storage)->Initialize();
    index = new InvertedIndex((IAStorage *)storage, new OAICorpus((const byte *)[directory cString]), new SimpleAnalysis());
    ((InvertedIndex *)index)->Initialize();

    return self;
}

- initWithIndex:(NSString *)filename forDirectory:(NSString *)directory;
{
    if (![super init])
        return nil;

    storage = MakeFileStorage([filename cString]);
    ((IAStorage *)storage)->Open(true);
    index = new InvertedIndex((IAStorage *)storage, new UFSDirectoryCorpus((const byte *)[directory cString]), new SimpleAnalysis());
    ((InvertedIndex *)index)->Open();

    return self;
}

- (void)dealloc;
{
    delete (InvertedIndex *)index;
    delete (IAStorage *)storage;
    [super dealloc];
}

// API

- (void)update;
{
    ((InvertedIndex *)index)->Update();
    ((InvertedIndex *)index)->Compact();
    ((IAStorage *)storage)->Commit();
}

- (void *)indexObject;
{
    return index;
}

@end
