// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// $Header: /LocalDeveloper/Source/CVS/OmniGroup/OmniAIAT/OAICorpus.h,v 1.3 1998/02/26 01:54:06 toon Exp $

#import <AIAT/UFSDirectoryCorpus.h>
#import <AIAT/UFSCorpus.h>

class OAIDocIterator : public IADocIterator {
public:
    OAIDocIterator(IADocIterator *originalIterator);
    ~OAIDocIterator();

    IADoc* GetNextDoc();
private:
    IADocIterator *original;
};

class OAICorpus : public UFSDirectoryCorpus {
public:
    OAICorpus(const byte *rootDirPath) : UFSDirectoryCorpus(rootDirPath) {}
    IADocIterator* GetDocIterator();
    IADocText* GetDocText(const IADoc *doc);
};

class OAIDocText : public UFSDocText {
public:
    OAIDocText(const byte *path);
    ~OAIDocText();
    
    void *GetExtension();
private:
    void *extension;
};