#import "Calendar.h"

@implementation Calendar


// awakeFromNib
// This is one of the last methods executed after the nib file is loaded.
// This is the BEST way I know how to initialize an object and jump into
// a method after the nib file was loaded.
- (void)awakeFromNib
{
       [self NowCalendar:NULL];
}


- (void)lastYear:(id)sender
// Subtracts 1 year from the current year.
{

	year--;
	if (year<1900) year =1900; // Does not go lower then that year.
        [self rebuildCalView:sender];

}


- (void)nextYear:(id)sender
// Adds 1 year to the current year.
{

		year++;
        	[self rebuildCalView:sender];

}



- (void)NextCalendar:(id)sender
// This displays the next month's calendar.
{

                if (month < 12)
                month++;
                else	{
                        year++;
                        month = 1;
                        }

                [self rebuildCalView:sender];
}


- (void)PreviousCalendar:(id)sender
// This displays the previous month's calendar.
{

                if (month > 1)
                month--;
                else	{
                        year--;
                        month = 12;
                        }

                [self rebuildCalView:sender];
}



- (void)NowCalendar:(id)sender
// This sets and displays the present month and year.
{
    	// Assigns current date using standard OpenStep API calls
	NSCalendarDate *TheCurrentDate = [NSCalendarDate date];

    	// Assigns current month using standard OpenStep API calls
	month = [TheCurrentDate monthOfYear];
        // Assigns current year using standard OpenStep API calls
	year  = [TheCurrentDate yearOfCommonEra];

        // This sets the current day in the TodaysDateDisplay.
        [TodaysDateDisplay setStringValue:[TheCurrentDate descriptionWithCalendarFormat:@"%A %B %d,  %Y"]];
       
        // Rebuild theCalView using updated data.
	[self rebuildCalView:sender];
}




- (void)PrintCalendar:(id)sender
{
}


- (void)rebuildCalView:(id)sender
// This method builds the current, previous and next calendars in the window.
{

	// Local Variables
	FILE *calCmd;
	char c, buff[256], *pbuff;
        int tempMonth, tempYear;

	// Display the current month
	sprintf( buff, "cal %d %d", month, year );
	if ( (calCmd=popen(buff, "r")) == NULL )
        [theCalView setStringValue:@"Can't build calendar!"];
	else {
        pbuff = buff;
        while( (c=fgetc(calCmd)) != EOF )
                *(pbuff++)=c;
        *pbuff='\0';
        pclose(calCmd);
        [theCalView setStringValue:[NSString stringWithCString:buff]];
        }


	// Display the previous month of the current month.
        if (month > 1)  {
                tempMonth = month - 1;
                tempYear = year;
                }
        else  {
                tempMonth = 12;
                tempYear = year - 1;
                }

        sprintf( buff, "cal %d %d", tempMonth, tempYear );
        if ( (calCmd=popen(buff, "r")) == NULL )
        [theCalView setStringValue:@"Can't build calendar!"];
        else {
        pbuff = buff;
        while( (c=fgetc(calCmd)) != EOF )
                *(pbuff++)=c;
        *pbuff='\0';
        pclose(calCmd);
        [CalViewPrevious setStringValue:[NSString stringWithCString:buff]];
        }


	// Display the next month after the current month.
        if (month < 12)  {
                tempMonth = month + 1;
                tempYear = year;
                }
        else  {
                tempMonth = 1;
                tempYear = year + 1;
                }

        sprintf( buff, "cal %d %d", tempMonth, tempYear );
        if ( (calCmd=popen(buff, "r")) == NULL )
        [theCalView setStringValue:@"Can't build calendar!"];
        else {
        pbuff = buff;
        while( (c=fgetc(calCmd)) != EOF )
                *(pbuff++)=c;
        *pbuff='\0';
        pclose(calCmd);
        [CalViewNext setStringValue:[NSString stringWithCString:buff]];
        }

        [calendarPanel makeKeyAndOrderFront:NULL];

}


- (void)SetYear:(id)sender
{

	year = [SelectYearDisplay intValue];
	[YearPanel performClose:sender];
	[self rebuildCalView:sender];

}


- (void)January:(id)sender
{
	month = 1;
	[self rebuildCalView:sender];
}


- (void)February:(id)sender
{
        month = 2;
        [self rebuildCalView:sender];
}


- (void)March:(id)sender
{
        month = 3;
        [self rebuildCalView:sender];
}


- (void)April:(id)sender
{
        month = 4;
        [self rebuildCalView:sender];
}


- (void)May:(id)sender
{
        month = 5;
        [self rebuildCalView:sender];
}

- (void)June:(id)sender
{
        month = 6;
        [self rebuildCalView:sender];
}

- (void)July:(id)sender
{
        month = 7;
        [self rebuildCalView:sender];
}


- (void)August:(id)sender
{
        month = 8;
        [self rebuildCalView:sender];
}


- (void)September:(id)sender
{
        month = 9;
        [self rebuildCalView:sender];
}


- (void)October:(id)sender
{
        month = 10;
        [self rebuildCalView:sender];
}


- (void)November:(id)sender
{
        month = 11;
        [self rebuildCalView:sender];
}


- (void)December:(id)sender
{
        month = 12;
        [self rebuildCalView:sender];
}



@end
