#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <libc.h>

#define  MAXLINE	512

void writeComment(FILE *fp, const unsigned char *comm)
{
	const unsigned char *p;
	unsigned char cc;

	for (p = comm; *p; p++) {
		if (*p == '\\') {
			putc('\\', fp);
			putc('\\', fp);
		}else if (*p >= ' ')
			putc(*p, fp);
		else {
			putc('\\', fp);
			cc = 0;
			switch (*p) {
			case '\b':	cc = 'b'; break;
			case '\f':	cc = 'f'; break;
			case '\n':	cc = 'n'; break;
			case '\r':	cc = 'r'; break;
			case '\t':	cc = 't'; break;
			}
			if (cc)
				putc(cc, fp);
			else
				fprintf(fp, "%03o", *p);
		}
	}
	putc('\n', fp);
}

unsigned char *readComment(unsigned char *comm)
{
	static unsigned char buf[MAXLINE + 4];
	int	x, i, cc;

	for (x = i = 0; i < MAXLINE && (cc = comm[x]) != 0; x++) {
		if (cc == '\\') {
			cc = comm[++x];
			switch (cc) {
			case 'b':	cc = '\b'; break;
			case 'f':	cc = '\f'; break;
			case 'n':	cc = '\n'; break;
			case 'r':	cc = '\r'; break;
			case 't':	cc = '\t'; break;
			case '0':
				cc = (comm[++x] & 0x07) << 3;
				cc |= (comm[++x] & 0x07);
				break;
			}
		}
		buf[i++] = cc;
	}
	buf[i] = 0;
	return buf;
}
