#import "TADocument.h"
#import <AppKit/NSSavePanel.h>
#import <Foundation/NSBundle.h>		/* LocalizedString */
#import <AppKit/NSPanel.h>		/* NSRunAlertPanel() */
#import <AppKit/NSWorkspace.h>
#import <Foundation/NSFileManager.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSAutoreleasePool.h>
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <libc.h>
#import <sys/types.h>
#import <sys/stat.h>
#import <sys/file.h>
#import "AlbumCtr.h"
#import "TACommon.h"
#import "TAController.h"
#import "ImageInfoNode.h"
#import "AlertShower.h"
#import "BundleLoader.h"
#import "Reduction.bproj/HTMLSaver.h"


@implementation TADocument (DocSave)

static NSFileManager *manager = nil;

/* Local Method */
- (NSString *)getSaveName:(NSString *)pathname with:(NSString *)suffix
{
	static NSSavePanel *savePanel = nil;
	static NSString *saveDir = nil;
	NSString *path, *fnam;
	NSString *sav = nil;

	if (!savePanel) {
		savePanel = [NSSavePanel savePanel];
		[savePanel retain];
	}
	path = [pathname stringByDeletingLastPathComponent];
	if (path == nil || [path length] == 0)
		path = saveDir ? saveDir : @"~";
	[savePanel setTreatsFilePackagesAsDirectories: NO];
	[savePanel setRequiredFileType:suffix];
	fnam = pathname ? [pathname lastPathComponent]
		: NSLocalizedString(@"Untitled", Untitled);
	if ([savePanel runModalForDirectory:path file:fnam]) {
		sav = [savePanel filename];
		if (sav == nil || [sav length] == 0)
			return nil;
		if (saveDir) [saveDir release];
		saveDir = [[NSString alloc]
			initWithString:[savePanel directory]];
	}
	return sav;
}

/* Local Method */
- (id)saveImage:(NSImage *)image asTiff:(NSString *)pname
{
	NSData *stream;

#ifdef _TEST_SAVE_
	printf("writing: %s\n", [pname cString]);
#endif
	if ((stream = [image TIFFRepresentationUsingCompression: 
			NSTIFFCompressionJPEG factor:25.0]) == nil)
		return nil;
	if ([manager createFileAtPath:pname contents:stream attributes:nil])
		return self;
	return nil;
}

/* Local Method */
- (BOOL)needThumb:(int)a or:(int)b
{
	float m = (thsize.width > thsize.height)? thsize.width : thsize.height;
	m /= 0.94;	/* See table of Shrinker... */
	return (a > m || b > m);
}

/* Local Method */
- (id)saveIndexAs:(NSString *)xname dir:(NSString *)dname newThumbnail:(int *)thname
{
	FILE	*fp;
	int	i, count, sn;

	if ((fp = fopen([xname cString], "w")) == NULL) {
		[ErrAlert runAlert:xname : Err_SAVE];
		return nil;
	}
	fprintf(fp, "#version %d\n", VERSION_NO);
	fprintf(fp, "#columns %d\n", columns);
	fprintf(fp, "#size %d %d\n", (int)(thsize.width), (int)(thsize.height));
	if (relative != m_absolute)
	    fprintf(fp, "#relative %d\n", (relative == m_relative_p) ? 2 : 1);
	fflush(fp); /* debug */
	count = [info count];
	sn = 0;
	for (i = 0; i < count; i++) {
		ImageInfoNode *a = [info objectAtIndex:i];
		NSString *f = [a filename];
		NSString *ifnam, *comm, *t;
		int width, height;
		long size;
		BOOL	isdummy;

		thname[i] = -1;
		if (f == nil || [f length] == 0) {
			fprintf(fp, "\n%c\n", DummySym);
			isdummy = YES;
		}else {
			isdummy = NO;
			fprintf(fp, "\n%c ", PathSym);
			t = f;
			if (![a isAbsolute]) {
				if ((t = [self pathRelativeToAlbum:f]) == nil)
					t = f;
			}
			fprintf(fp, "\"%s\"\n", [t cString]);
		}
		comm = [a comment];
		if (comm && [comm length] > 0) {
			fprintf(fp, "%c ", CommSym);
			writeComment(fp, [comm cString]);
		}
		if (isdummy) {
			fflush(fp); /* debug */
			continue;
		}

		width = [a width];
		height = [a height];
		size = [a size];
		ifnam = [a iconname];
		if (ifnam != nil && [ifnam length] > 0) {
			fprintf(fp, "%c \"%s\"\n", IconSym,
				[[ifnam lastPathComponent] cString]);
		}else if (([a isAbsolute] && width > 0 && height > 0)
				|| [self needThumb:width or:height]) {
		    NSString *iname, *pname;
		    /* Set only thumbnail file name here */
		    do {
			iname = [NSString stringWithFormat:@"%04d.%@", ++sn, TiffSFX];
			pname = [dname stringByAppendingPathComponent:iname];
		    }while ([manager fileExistsAtPath:pname]);
		    thname[i] = sn;	/* New name */
		    fprintf(fp, "%c \"%s\"\n", IconSym, [iname cString]);
		    [a setIconname: pname];
		}
		fprintf(fp, "%c %d %d %ld\n", SizeSym, width, height, size);
		fflush(fp); /* debug */
	}
	fclose(fp);
	return self;
}

- (id)saveIndexAndIconsAs:(NSString *)dname
{
	NSString *xname;
	int	i, count;
	int	*thname = NULL;
	NSAutoreleasePool *pool = nil;
	id	res = self;

	xname = [dname stringByAppendingPathComponent:IndexFile];
	if ([manager fileExistsAtPath:xname])
		(void) unlink([xname cString]);
		/* [manager removeFileAtPath:xname handler:self]; */
	if ((count = [info count]) <= 0) {
		NSBeep();	/* Nothing to save */
		return nil;
	}
	thname = (int *)malloc(sizeof(int) * count);
	pool =[[NSAutoreleasePool alloc] init];
	res = [self saveIndexAs:xname dir:dname newThumbnail:thname];
	[pool release];
	if (res == nil)
		goto Exit;

	for (i = 0; i < count; i++) {
		ImageInfoNode *a;
		NSString *pname, *iname;
		if (thname[i] < 0)
			continue;
		a = [info objectAtIndex:i];
		iname = [NSString stringWithFormat:@"%04d.%@", thname[i], TiffSFX];
		pname = [dname stringByAppendingPathComponent: iname];
		if ([self saveImage:[a image] asTiff:pname] == nil) {
			[ErrAlert runAlert:pname : Err_SAVE];
			res = nil;
			goto Exit;
		}
	}
	[[NSWorkspace sharedWorkspace] noteFileSystemChanged];
Exit:
	if (thname) free((void *)thname);
	return res;
}

/* Local Method */
- (id)saveAllInfo:(NSString *)dname
{
	int	i, count;
	id	result;
	NSString *msg, *sav;

	msg = NSLocalizedString(@"Saving this album.  Wait.", SavingAlbum);
	sav = [albumctr displayMessage: msg];
	count = [info count];
	for (i = 0; i < count; i++)
		[[info objectAtIndex: i] setIconname: nil];
	result = [self saveIndexAndIconsAs:dname];
	(void)[albumctr displayMessage: sav];
	return result;
}

- (BOOL)checkDirectoryPath:(NSString *)newname mode:(relativ_t *)relflag
{
	NSString *ddir, *ndir;
	BOOL	altflag = YES;
	ddir = [docname stringByDeletingLastPathComponent];
	ndir = [newname stringByDeletingLastPathComponent];
	
	if ([ndir isEqualToString:ddir])
		altflag = NO;
	else if (relative == m_relative) {
		ddir = [ddir stringByDeletingLastPathComponent];
		if ([ndir isEqualToString:ddir]) {
			*relflag = m_relative_p;
			altflag = NO;
		}
	}
	if (altflag) {
		NSString *stop, *cont, *mesg;
		int	rslt;
		stop = NSLocalizedString(@"Cancel", CANCEL);
		cont = NSLocalizedString(@"Yes", YES);
		mesg = NSLocalizedString(@"Save as absolute path mode?", SaveAsAbs);
		rslt = NSRunAlertPanel(AppName, mesg, cont, stop, nil);
		if (rslt != NSAlertDefaultReturn)
			return NO;	/* cancel */
		*relflag = m_absolute;
	}
	return YES;
}

- (id)saveDocAs:sender
{
	NSString *newname;

	if (manager == nil)
		manager = [NSFileManager defaultManager];
	newname = [self getSaveName:docname with:Suffix];
	if (newname == nil || [newname length] == 0)
		return nil;	/* cancel */
	if (relative != m_absolute) {
		relativ_t flag;
		if (![self checkDirectoryPath: newname mode:&flag])
			return nil;	/* cancel */
		relative = flag;
	}

	if ([manager fileExistsAtPath:newname]) { /* delete */
		if (![manager removeFileAtPath:newname handler:self]) {
			// [ErrAlert runAlert:newname : Err_SAVE];
			return nil;
		}
	}
	if (![manager createDirectoryAtPath:newname attributes:nil]) {
		[ErrAlert runAlert:newname : Err_SAVE];
		return nil;
	}
	if ([self saveAllInfo:newname]) {
		[docname release];
		[(docname = newname) retain];
		[window setTitleWithRepresentedFilename: docname];
		[albumctr setDocumentEdited:NO];
		[albumctr setIsNew:NO];
	}
	return self;
}

/* Local Method */
- (id)savePartial
{	/* directory 'docname' must exist */
	int	i, fx, icount, fcount;
	BOOL	xflag;
	id dirfiles;
	NSString *iconstr, *filestr;

	dirfiles = [manager directoryContentsAtPath: docname];
	if (dirfiles == nil || [dirfiles count] <= 0)
		return [self saveAllInfo:docname];

	dirfiles = [NSMutableArray arrayWithArray:dirfiles];
	fcount = [dirfiles count];
	for (fx = 0; fx < fcount; ) {
		filestr = [dirfiles objectAtIndex: fx];
		if ([[filestr pathExtension] isEqualToString: TiffSFX])
			fx++;
		else {
			[dirfiles removeObjectAtIndex: fx];
			fcount--;
		}
	}
	icount = [info count];
	for (i = 0; i < icount; i++) {
		iconstr = [[info objectAtIndex: i] iconname];
		if (iconstr == nil || [iconstr length] <= 0)
			continue;
		iconstr = [iconstr lastPathComponent];
		xflag = NO;
		fcount = [dirfiles count];
		for (fx = 0; fx < fcount; fx++) {
			filestr = [dirfiles objectAtIndex: fx];
			if ([iconstr isEqualToString: filestr]) {
				[dirfiles removeObjectAtIndex: fx];
				xflag = YES;
				break;
			}
		}
		if (!xflag)
			[[info objectAtIndex: i] setIconname: nil];
	}
	fcount = [dirfiles count];
	for (fx = 0; fx < fcount; fx++) { /* Remove */
		filestr = [docname stringByAppendingPathComponent:
				[dirfiles objectAtIndex: fx]];
		[manager removeFileAtPath:filestr handler:self];
	}
	return [self saveIndexAndIconsAs:docname];
}

- (id)saveDoc:sender
{
	if (manager == nil)
		manager = [NSFileManager defaultManager];
	if (docname == nil || [docname length] == 0)  /* maybe new doc */
		return [self saveDocAs:sender];
	if ([manager fileExistsAtPath:docname]) {
		NSString *stop, *renm, *cont, *mesg;
		int	result;

		if (![albumctr isNew]) {
			/* Save Edited Album */
			if ([self savePartial]) {
				[albumctr setDocumentEdited:NO];
				return self;
			}
			return nil;
		}
		/* This doc is created newly, but there is a dir
		of the same name.  Overwrite or rename ? */

		stop = NSLocalizedString(@"Cancel", CANCEL);
		cont = NSLocalizedString(@"Over Write", OverWrite);
		renm = NSLocalizedString(@"Use Other Name", UseOtherName);
		mesg = NSLocalizedString(@"Album \'%@\' is already there.", SameName);
		result = NSRunAlertPanel(AppName, mesg,
			renm, cont, stop, [docname lastPathComponent]);
		switch  (result) {
		case NSAlertDefaultReturn: /* Rename */
			return [self saveDocAs:sender];
		case NSAlertAlternateReturn: /* OverWrite */
			break;
		default: /* Cancel: NSAlertOtherReturn */
			return nil;
		}
		/* delete */
		[manager removeFileAtPath:docname handler:self];
	}
	/* new doc */
	if (![manager createDirectoryAtPath:docname attributes:nil]) {
		[ErrAlert runAlert:docname : Err_SAVE];
		return nil;
	}
	if ([self saveAllInfo:docname]) {
		[albumctr setDocumentEdited:NO];
		[albumctr setIsNew:NO];
	}
	return self;
}

- (id)saveHTMLDocAs:sender
{
	id saver;

	if ((saver = [BundleLoader loadAndNew:b_HTMLSaver]) == nil)
		return nil;
	[saver setDoc:self andInfo:info];
	[saver saveHTMLDocAs:self];
	[saver release];
	return self;
}

- (id)saveHTMLDocAndReadyToClose:(BOOL *)attributes
{
	id saver;

	if ((saver = [BundleLoader loadAndNew:b_HTMLSaver]) == nil)
		return nil;
	[saver setDoc:self andInfo:info];
	[saver setHTMLattributes:attributes];
	[saver saveHTMLDoc:self];
	[saver release];
	[albumctr setDocumentEdited:NO];
	return self;
}

/* Error Handler */
- (BOOL)fileManager:(NSFileManager *)manager 
	shouldProceedAfterError:(NSDictionary *)errorDict
{
	int result;
	NSString *stop, *cont, *mesg;

	stop = NSLocalizedString(@"Cancel", CANCEL);
	cont = NSLocalizedString(@"Continue", CONTINUE);
	mesg = NSLocalizedString(@"File operation error", FileOpError);
	result = NSRunAlertPanel(AppName, mesg, cont, stop, NULL, 
		[errorDict objectForKey:@"Error"], 
		[errorDict objectForKey:@"Path"]);
	if (result == NSAlertDefaultReturn)
		return YES;
	else
		return NO;
}

@end
