#import "SizeInspector.h"
#import <Foundation/NSBundle.h>
#import "TACommon.h"
#import "TAController.h"
#import "TADocument.h"
#import "PhotoCell.h"
#import "ResizeButton.h"

#define  SzInsWindowName	@"SizeInspector"

@implementation SizeInspector

- (void)activateInspector:(id)ctrl
{
	controller = ctrl;
	if ([controller keyWindow] == nil) {
		NSBeep();
		return;
	}
	if (panel == nil) {
		[NSBundle loadNibNamed:@"SizeInspector.nib" owner:self];
		currentDoc = nil;
	}

	[panel setFrameUsingName:SzInsWindowName];
	[panel makeKeyAndOrderFront:self];
	[self notifyCurrentDoc:self];
}

/* Local Method */
- (float)sizeToFloat:(NSSize)sz
{
	int	w;

	if (sz.width == sz.height) {
		thwidth = sz.width;
		return 0.0;
	}
	if (sz.width >= sz.height) {
		thwidth = sz.width;
		w = thwidth - ((int)sz.height & ~03);
	}else {
		thwidth = sz.height;
		w = ((int)sz.width & ~03) - thwidth;
	}
	if (thwidth <= P_MIN_Size)
		return 0.0;
	return (float)w / (thwidth - P_MIN_Size);
}

/* Local Method */
- (void)locateButton
{
	float d;
	NSRect brec;
	NSRect fr = [areaFrame frame];
	brec.size.width = testSize.width + M_Width;
	brec.size.height = testSize.height + M_Height;
	brec.origin = fr.origin;
	if ((d = (fr.size.width - brec.size.width) / 2) > 0.0)
		brec.origin.x += d;
	if ((d = (fr.size.height - brec.size.height) / 2) > 0.0)
		brec.origin.y += d;
	[areaFrame display];
	[sampleButton setFrame:brec];
}

- (void)notifyCurrentDoc:(id)sender
{
	id	newdoc;
	ImageInfoNode *node;

	if (panel == nil)
		return;
	newdoc = [controller keyWindow];
	if (newdoc == currentDoc) {
		[sampleButton setInfo:[currentDoc imageInfoAtSelectedCell]];
		[sampleButton setThumbSize:testSize];
		[sampleButton showImage];
		return;
	}
	currentDoc = newdoc;
	if (newdoc == nil) {
		[panel performClose:self];
		// panel = nil; <-- this is done in delegate method.
		return;
	}

	node = [currentDoc imageInfoAtSelectedCell];
	testSize = [node thumbSize];
	[sizeSlider setFloatValue:[self sizeToFloat:testSize]];
	[self locateButton];
	[sampleButton setInfo:node];
	[sampleButton showImage];
}

- (void)changeSize:(id)sender
{
	int z;
	float v = [sender floatValue];
	if (v == 0.0)
		testSize.width = testSize.height = thwidth;
	else if (v > 0.0) {
		testSize.width = thwidth;
		z = thwidth - (thwidth - P_MIN_Size) * v;
		testSize.height = z & ~03;
	}else {
		testSize.height = thwidth;
		z = thwidth + (thwidth - P_MIN_Size) * v;
		testSize.width = z & ~03;
	}
	[self locateButton];
	[sampleButton setThumbSize:testSize];
	[sampleButton showImage];
}

- (void)ok:(id)sender
{
	if (currentDoc == nil)
		return;
	[currentDoc setThumbnailSize:testSize];
}

- (void)resetSize:(id)sender
{
	[sizeSlider setFloatValue: 0.0];
	[self changeSize:sizeSlider];
}

- (void)testDisplay:(id)sender
{
	[self notifyCurrentDoc: self];
}

/* delegate methods */
- (BOOL)windowShouldClose:(id)sender
{
	[panel saveFrameUsingName:SzInsWindowName];
	panel = nil;
	return YES;
}

@end
