#import <stdlib.h>

int byte_length(int bits, int width)
{
	switch (bits) {
	case 1: return ((width + 7) >> 3);
	case 2: return ((width + 3) >> 2);
	case 4: return ((width + 1) >> 1);
	case 8:
	default:
		break;
	}
	return width;
}

int allocImage(unsigned char **planes,
	int width, int height, int repbits, int pnum)
{
	int i, xbyte, wd;
	unsigned char *p;

	xbyte = byte_length(repbits, width);
	wd = xbyte * height;
	if ((p = (unsigned char *)malloc(wd * pnum)) == NULL)
		return (-1); /* Err_MEMORY */
	for (i = 0; i < pnum; i++) {
		planes[i] = p;
		p += wd;
	}
	if (pnum < 5) planes[pnum] = NULL;
	return 0;
}
