#import  "GifSavePanel.h"
#import  <AppKit/NSApplication.h>
#import  <AppKit/NSControl.h>
#import  <AppKit/NSButton.h>
#import  "../TACommon.h"
#import  "../PrefControl.h"

#define  Tag_htmld	0
#define  Tag_none	1

@implementation GifSavePanel

- (void)loadNib
{
	BOOL html[HTML_BOOLS];

	if ([self accessoryView] == nil) {
		[NSBundle loadNibNamed:@"GifAccessory.nib" owner:self];
		[self setAccessoryView:[accessory contentView]];
	}
	[InterSW setState:NO]; 
	[thePreference defaultHTML:html];
	[InterSW setState:html[HTML_interlace]];
	[noFilenameSW setState:html[HTML_nofilename]];
	[noSizeSW setState:html[HTML_nosizeinfo]];
}

- (BOOL)interlace { return [InterSW state]; }
- (BOOL)noFilename { return [noFilenameSW state]; }
- (BOOL)noSize { return [noSizeSW state]; }

- (NSString *)suffix
{
	return ([suffixButton selectedTag] == Tag_htmld) ? HTMLDirSuffix : nil;
}

/* NOTE: This method uses "_form", which is an instance variable of
   superclass NSSavePanel.  Be careful. */
- (void)changeSuffix: sender
{
	NSString *name, *sufx;

	name = [_form stringValue];
	if (name == nil || [name length] == 0)
		return;
	sufx = [self suffix];
	if ([name hasSuffix:HTMLDirSuffixWd]) {
		if (sufx == nil)
			name = [name stringByDeletingPathExtension];
		else
			return;
	}else {
		if (sufx != nil)
			name = [name stringByAppendingPathExtension: sufx];
		else
			return;
	}
	[_form setStringValue: name];
}

@end
