#import  <AppKit/AppKit.h>
#import  "../common.h"
#import  "colormapsub.h"

#if EnoughMemory
# define  COLORSTEPS		65536	/* = 0x10000 */
# define  MAXColors		62000	/* < COLORSTEPS */
#else
# define  COLORSTEPS		32768	/* = 32 ^ 3 = 0x8000 */
# define  MAXColors		30000	/* < COLORSTEPS */
#endif

@interface ColorMap:NSObject

- init;
- allocFullColor;
- (void)dealloc;
- init_regColor;
- (void)shiftMask;
- (int)regColorToMap: (int)red : (int)green : (int)blue;
- (int)getAllColor:(unsigned char **)map limit:(int)limit alpha:(BOOL *)alpha;
- (int)getAllColor:(unsigned char **)map limit:(int)limit;
- (paltype *)getNormalmap:(int *)cnum;
- (paltype *)getReducedMap:(int *)cnum alpha:(BOOL)alpha;
- (paltype *)getPalette;

// - (void)setFourBitsPalette:(BOOL)flag;
// - allocPalColor;
// - (int)regPalColorWithAlpha:(BOOL)alpha;
// - (void)regGivenPal:(paltype *)gpal colors:(int)cnum;

@end

int mapping(int, int, int);
