#import "PrefControl.h"
#import <Foundation/NSUserDefaults.h>
#import <Foundation/NSNotification.h>
#import <AppKit/NSFont.h>
#import <AppKit/NSFontManager.h>
#import <AppKit/NSFontPanel.h>
#import "TACommon.h"
#import "PhotoCell.h"
#import "TAController.h"
#import "PowerSlider.h"
#import "ModeDisplay.h"
#import "common.h"
#import "getpixel.h"

#define  SystemFont	@"NSFont"
#define  FontName	@"FontName"
#define  FontSize	@"FontSize"
#define  FontNameDef	@"Helvetica"
#define  FontSizeDef	12.0
#define  AlbumName	@"AlbumName"
#define  DefWidth	@"DefaultWidth"
#define  DefWidthDef	6
#define  DefMode	@"DefaultMode"
#define  DefSort	@"DefaultSort"
#define  DefSortDef	Sort_Name
#define  DefSize	@"DefaultSize"
#define  WithSuffix	@"WithSuffix"
#define  DottedFile	@"DottedFile"
#define  IncludeAlbum	@"IncludeAlbum"
#define  TransColor	@"TransColor"
#define  HTMLInterlace	@"HTMLInterlace"
#define  HTMLNoFileName	@"HTMLNoFileName"
#define  HTMLNoSizeInfo	@"HTMLNoSizeInfo"
#define  DefTransColor	0

static NSUserDefaults *usrdef = nil;

/* extern */ PrefControl *thePreference = nil;

@implementation PrefControl

/* Local Method */
- (void)showFontname
{
	NSString *s, *name;

	name = [currentfont fontName];
	// name = [currentfont displayName];
	/* Method "displayName" of NSFont is BUGGY.  It occurs warning:
		***warning: Object compatibility method 'dealloc' in class 
		NXStringTable has been executed at least once
	and sometimes makes fatal error:
		Program generated(1): Memory access exception on address 
		0x36e113 (invalid address).
	*/
	s = [NSString stringWithFormat:@"%@ %5.1fpt", 
			name, [currentfont pointSize]];
	[fontText setStringValue: s];
}

- (id)init
{
	NSString *s;
	float	fontsize;

	[super init];
	thePreference = self;
	usrdef = [NSUserDefaults standardUserDefaults];

/* Font */
	if ((s = [usrdef stringForKey:FontName]) == nil) {
		fontsize = FontSizeDef;
		currentfont = [NSFont userFontOfSize: fontsize];
	}else {
		fontsize = [usrdef floatForKey:FontSize];
		if (fontsize < 4.0 || fontsize > 64.0)
			fontsize = FontSizeDef;
		currentfont = [NSFont fontWithName:s size:fontsize];
	}
	if (!currentfont)
		currentfont = [NSFont fontWithName:FontNameDef size:fontsize];
	[PhotoCell setCurrentFont: currentfont];

/* AlbumName */
	s = [usrdef stringForKey:AlbumName];
	[(albname = s) retain];

/* Width */
	if ((width = [usrdef integerForKey:DefWidth]) <= 0)
		width = DefWidthDef;

/* Mode */
	if ((albmode = [usrdef integerForKey:DefMode]) <= 0)
		albmode = m_relative;

/* Sort */
	if ((sorting = [usrdef integerForKey:DefSort]) <= 0)
		sorting = DefSortDef;

/* Thumbnail Size */
	if ((thsize = [usrdef integerForKey:DefSize]) <= 0)
		thsize = P_Width;

/* With Suffix */
	wsuffix = ([usrdef objectForKey:WithSuffix] == nil)
		? YES	// Default
		: [usrdef boolForKey:WithSuffix];
	[PhotoCell setWithSuffix: wsuffix];

/* Dotted File */
	dotted = [usrdef boolForKey:DottedFile];

/* Include Albums */
	includealb = ([usrdef objectForKey:IncludeAlbum] == nil)
		? YES	// Default
		: [usrdef boolForKey:IncludeAlbum];

/* TransColor */
	if ((transcolor = [usrdef integerForKey:TransColor]) <= 0)
		transcolor = DefTransColor;
	if (transcolor == 0)
		setTransColor(0, 0, 0);		/* Black */
	else
		setTransColor(255, 255, 255);	/* White */

/* HTML */
	HTMLvals[HTML_interlace] = [usrdef boolForKey:HTMLInterlace];
	HTMLvals[HTML_nofilename] = [usrdef boolForKey:HTMLNoFileName];
	HTMLvals[HTML_nosizeinfo] = [usrdef boolForKey:HTMLNoSizeInfo];

	return self;
}

- (void)makeKeyAndOrderFront:(id)sender
{
	if (prefPanel == nil) {
		id	sizeSlider;
		[NSBundle loadNibNamed:@"Preference.nib" owner:self];
		[self showFontname];
		[albumNameText setStringValue:(albname ? albname : @"")];
		[widthSlider setIntValue:width];
		[widthText setIntValue:width];
		[modeSW selectCellWithTag:albmode];
		[modeText setModeMessageWith:albmode];
		[sortSW selectCellWithTag:sorting];
		[transSW selectCellWithTag:transcolor];
		sizeSlider = [sizeText target];
		[sizeSlider setMaxValue:(double)MAX_THUMBNAIL];
		[sizeSlider setMinValue:(double)MIN_THUMBNAIL];
		[sizeSlider setStep:8];
		[sizeSlider setIntValue: thsize];
		[sizeText setIntValue: thsize];
		[suffixCB setState: wsuffix];
		[showDotted setState: dotted];
		[includeAlbum setState: includealb];
		[HTMLinterlace setState: HTMLvals[HTML_interlace]];
		[HTMLnoFilename setState: HTMLvals[HTML_nofilename]];
		[HTMLnoSizeinfo setState: HTMLvals[HTML_nosizeinfo]];
	}
	[prefPanel makeKeyAndOrderFront:sender];
}

- (void)setFontname:(id)sender
{
	NSFontManager *fontManager = [NSFontManager sharedFontManager];
	[prefPanel makeFirstResponder:prefPanel];
	[fontManager setSelectedFont:currentfont isMultiple:NO];
	[fontManager orderFrontFontPanel:self];
}

- (void)changeSuffix:(id)sender
{
	wsuffix = [suffixCB state];
	[PhotoCell setWithSuffix: wsuffix];
	[[NSNotificationCenter defaultCenter]
		postNotificationName:SuffixDidChange object:self];
}

- (NSFont *)currentFont { return currentfont; }
- (NSString *)defaultAlbumName { return albname; }
- (int)defaultWidth { return width; }
- (int)defaultMode { return albmode; }
- (int)defaultSorting { return sorting; }
- (int)defaultThumbSize { return thsize; }
- (BOOL)showDottedFiles { return dotted; }
- (BOOL)showSuffixOfFiles { return wsuffix; }
- (BOOL)includeAlbumFiles { return includealb; }
- (BOOL)synchronize { return [usrdef synchronize]; }

- (void)defaultHTML:(BOOL *)boolarray
{
	int	i;
	for (i = 0; i < HTML_BOOLS; i++)
		boolarray[i] = HTMLvals[i];
}

/* Local Method */
- (void)updatePref:(id)sender
{
	NSString *s;

	/* No need to update Font */
	s = [albumNameText stringValue];
	[albname release];
	if (s == nil || [s length] <= 0) {
		[usrdef removeObjectForKey:AlbumName];
		albname = nil;
	}else {
		[(albname = s) retain];
		[usrdef setObject:albname forKey:AlbumName];
	}
	width = [widthText intValue];
	[usrdef setInteger:width forKey:DefWidth];
	albmode = [modeSW selectedTag];
	[usrdef setInteger:albmode forKey:DefMode];
	sorting = [sortSW selectedTag];
	[usrdef setInteger:sorting forKey:DefSort];
	thsize = [sizeText intValue];
	[usrdef setInteger:thsize forKey:DefSize];
	transcolor = [transSW selectedTag];
	if (transcolor == 0)
		setTransColor(0, 0, 0);		/* Black */
	else
		setTransColor(255, 255, 255);	/* White */

	dotted = [showDotted state];
	[usrdef setBool:dotted forKey:DottedFile];
	includealb = [includeAlbum state];
	[usrdef setBool:includealb forKey:IncludeAlbum];

	[usrdef setBool:wsuffix forKey:WithSuffix];

	HTMLvals[HTML_interlace] = [HTMLinterlace state];
	[usrdef setBool:HTMLvals[HTML_interlace] forKey:HTMLInterlace];
	HTMLvals[HTML_nofilename] = [HTMLnoFilename state];
	[usrdef setBool:HTMLvals[HTML_nofilename] forKey:HTMLNoFileName];
	HTMLvals[HTML_nosizeinfo] = [HTMLnoSizeinfo state];
	[usrdef setBool:HTMLvals[HTML_nosizeinfo] forKey:HTMLNoSizeInfo];
}

/* Delegate Method */
- (BOOL)windowShouldClose:(id)sender
{
	[self updatePref:self];
	return YES;
}

- (void)changeFont:(id)fontManager
{
	NSFont *w;

	w = [fontManager convertFont:currentfont];
	[[fontManager fontPanel:NO] performClose:self];
	if (w == currentfont)
		return;
	currentfont = w;
	[self showFontname];
	[usrdef setObject:[currentfont fontName] forKey:FontName];
	[usrdef setFloat:[currentfont pointSize] forKey:FontSize];
	[PhotoCell setCurrentFont: currentfont];
	[[NSNotificationCenter defaultCenter]
		postNotificationName:FontDidChange object:self];
}

@end
