#import <AppKit/AppKit.h>
#import "TACommon.h"

@class NSFont;

@interface PrefControl : NSObject
{
	id	prefPanel;
	id	fontText;
	id	widthSlider;
	id	widthText;
	id	modeSW;
	id	modeText;
	id	sortSW;
	id	transSW;
	id	sizeText;
	id	suffixCB;
	id	albumNameText;
	id	showDotted;
	id	includeAlbum;
	id	HTMLinterlace;
	id	HTMLnoFilename;
	id	HTMLnoSizeinfo;
	NSFont	*currentfont;
	int	width;
	int	albmode;
	int	sorting;
	int	transcolor;
	int	thsize;
	NSString *albname;
	BOOL	wsuffix;
	BOOL	dotted;
	BOOL	includealb;
	BOOL	HTMLvals[HTML_BOOLS];
}

- (id)init;
- (void)makeKeyAndOrderFront:(id)sender;
- (void)setFontname:(id)sender;
- (void)changeSuffix:(id)sender;
- (NSFont *)currentFont;
- (NSString *)defaultAlbumName;
- (int)defaultWidth;
- (int)defaultMode;
- (int)defaultSorting;
- (int)defaultThumbSize;
- (BOOL)showDottedFiles;
- (BOOL)showSuffixOfFiles;
- (BOOL)includeAlbumFiles;
- (BOOL)synchronize;
- (void)defaultHTML:(BOOL *)boolarray;

/* Delegate Method */
- (BOOL)windowShouldClose:(id)sender;
- (void)changeFont:(id)fontManager;

@end

extern PrefControl *thePreference;
