#import "PhotoCell.h"
#import <AppKit/NSText.h>
#import <AppKit/NSImage.h>
#import <AppKit/NSFont.h>
#import <AppKit/psopsOpenStep.h>
#import <AppKit/NSWorkspace.h>
#import "TACommon.h"

static NSFont *currentFont;
static BOOL withSuffix;

@implementation PhotoCell

+ (void)setCurrentFont:(NSFont *)font
{
	currentFont = font;
}

+ (void)setWithSuffix:(BOOL)flag
{
	withSuffix = flag;
}

- init
{
	[super init];
	info = nil;
	[self setImagePosition: NSImageAbove];
	[self setBezeled:YES];
	[self setButtonType:NSOnOffButton];
	[self setAlignment:NSCenterTextAlignment];
	[self setShowsFirstResponder:NO];
	[self setTitle:@""];
	return self;
}

- (void)setInfo:(ImageInfoNode *)node
{
	info = node;	/* Only has a pointer. (without 'retain') */
	if (info) {
		NSString *fnam;
		[self setEnabled:YES];
		[self setTransparent:NO];
		if ((fnam = [info filename]) != nil && [fnam length] > 0) {
			if (currentFont)
				[self setFont: currentFont];
			[self resetTitle];
		}else
			[self setTitle:@""];
	}else { /* last buttons */
		[self setTransparent:YES];
		[self setEnabled:NO];
		[self setTitle:@""];
		[self setImage:nil];
	}
}

- (ImageInfoNode *)info
{
	return info;
}

- (void)showIconImage
{
	NSImage *img, *newimg;
	NSSize thsz, imsz, newsz;
	NSPoint pnt;

	if (info == nil)
		return;
	if ((img = [info setIconImage]) == nil) {
		[self setImage:nil];
		return;
	}
	imsz = [img size];
	thsz = [info thumbSize];
	if (imsz.width <= thsz.width && imsz.height <= thsz.height) {
		[self setImage:img];
		return;
	}
	newsz.width = (imsz.width <= thsz.width) ? imsz.width : thsz.width;
	newsz.height = (imsz.height <= thsz.height)? imsz.height : thsz.height;
	pnt.x = (int)(newsz.width - imsz.width) / 2;
	pnt.y = (int)(newsz.height - imsz.height) * 4 / 5;
	newimg = [[NSImage alloc] initWithSize:newsz];
	[newimg lockFocus];
	[img compositeToPoint:pnt operation:NSCompositeCopy];
	[newimg unlockFocus];
	[self setImage:newimg];
	[newimg release];
}

- (NSString *)filename
{
	return (info ? [info filename] : nil);
}

- (NSImage *)iconImage
{
	return (info ? [info image] : nil);
}

- (void)resetFont
{
	if (info && currentFont)
		[self setFont: currentFont];
}

- (void)resetTitle
{
	NSString *fnam, *ttl;

	if ((ttl = [info titlename]) == nil) {
		fnam = [info filename];
		if (fnam && [fnam length] > 0)
			ttl = [fnam lastPathComponent];
		else
			ttl = @"";
	}
	if (!withSuffix)
		ttl = [ttl stringByDeletingPathExtension];
	[self setTitle: ttl];
}

@end
