#import "TADocMaker.h"
#import <AppKit/NSApplication.h>
#import <AppKit/NSColor.h>
#import <Foundation/NSFileManager.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSData.h>
#import <Foundation/NSBundle.h>	/* LocalizedString */
#import <AppKit/NSPanel.h>	/* NSRunAlertPanel() */
#import <AppKit/NSImage.h>
#import <AppKit/NSPasteboard.h>
#import <stdio.h>
#import <stdlib.h>
#import "../TACommon.h"
#import "../TAController.h"
#import "../TADocument.h"
#import "../ImageInfoNode.h"
#import "../AlertShower.h"
#import "../ModeDisplay.h"
#import "../PrefControl.h"
#import "TwinSliderCtrl.h"
#import "Regexp.h"
#import "DirTravCtrl.h"

#define  NewDocWindowName	@"NewDoc"

static TADocMaker *theDocMaker = nil;
static NSString *odir = nil;	/* Last Opened Directory */

@implementation TADocMaker

+ (void)setLastOpenedDirectory:(NSString *)dir
{
	[odir release];
	odir = [dir retain];
}

+ (NSString *)lastOpenedDirectory
{
	if (odir == nil)
		odir = [NSHomeDirectory() copyWithZone:[self zone]];
	return odir;
}

+ (id)defaultDocMaker
{
	if (theDocMaker == nil)
		theDocMaker = [[[self alloc] init] retain];
	return theDocMaker;
}

- (id)init
{
	[super init];
	[NSBundle loadNibNamed:@"DocMaker.nib" owner:self];
	[infoPanel setDelegate:self];
	[infoPanel registerForDraggedTypes:
		[NSArray arrayWithObject: NSFilenamesPboardType]];
	[thumbSliders setValue:P_Width and:P_Width];
	thumbsz.width = thumbsz.height = P_Width;
	regx = nil;
	newNamePath = targetPath = nil;
	traversing = NO;
	return self;
}

- (void)dealloc
{
	[regx release];
	[super release];
}

- (void)makeNewDocument:sender
{
	int	sz, mode;
	BOOL html[HTML_BOOLS];

	if (traversing) {
		[WarnAlert runAlert:nil : Warn_Traverse];
		return;
	}
	[directoryText setStringValue:@""];
	[albumText setStringValue:@""];
	[regText setStringValue:@""];
	[regText setBackgroundColor:[NSColor lightGrayColor]];
	[regText setEnabled:NO];
	[regSW setState:NO];
	[caseSW setState:YES];
	[caseSW setEnabled:NO];
	colnum = [thePreference defaultWidth];
	[widthText setIntValue:colnum];
	[[widthText target] setIntValue:colnum];
	mode = [thePreference defaultMode];
	[modeSW selectCellWithTag:mode];
	[modeText setModeMessageWith:mode];
#ifdef WITH_SORT_SW
	[sortSW selectCellWithTag:[thePreference defaultSorting]];
#endif
	sz = [thePreference defaultThumbSize];
	[thumbSliders setValue:sz and:sz];
	[albumButton setEnabled:NO];
	[thePreference defaultHTML:html];

	[HTMLinterlace setState:html[HTML_interlace]];
	[HTMLnoFilename setState:html[HTML_nofilename]];
	[HTMLnoSizeinfo setState:html[HTML_nosizeinfo]];
	[self changeTrav:self];

	[infoPanel setFrameUsingName:NewDocWindowName];
	[infoPanel makeKeyAndOrderFront:self];
}

- (BOOL)makeNewDocumentWith:(NSString *)fname
{
	BOOL	isdir = NO;

	if (traversing) {
		[WarnAlert runAlert:nil : Warn_Traverse];
		return NO;
	}
	if (![[NSFileManager defaultManager]
		fileExistsAtPath:fname isDirectory:&isdir] || !isdir)
		return NO;
	[self makeNewDocument: self];
	[directoryText setStringValue:fname];
	return YES;
}

- (void)referDirectory:sender
{
	NSArray  *files;
	NSString *filename, *ldir, *nwdir;
	BOOL	isdir;
	int	rtn;
	static id openPanel = nil;

	if (openPanel == nil)
		openPanel = [[NSOpenPanel openPanel] retain];
	isdir = ([sender tag] == 0);
	[openPanel setCanChooseDirectories:YES];
	[openPanel setAllowsMultipleSelection:NO];
	[openPanel setTitle: isdir ? @"Image Directory" : @"Album"];
	ldir = [[self class] lastOpenedDirectory];
	rtn = [openPanel runModalForDirectory:ldir file:nil types:nil];
	if (rtn != NSOKButton)
		return;
	files = [openPanel filenames];
	nwdir = [openPanel directory];
	[[self class] setLastOpenedDirectory:nwdir];
	filename = [files objectAtIndex: 0];
	if (isdir)
		[directoryText setStringValue:filename];
	else
		[albumText setStringValue:filename];
}

- (void)changeMode:sender
{
	int tag = [modeSW selectedTag];
	[modeText setModeMessageWith:tag];
	[albumButton setEnabled:(tag == m_absolute)];
	if ([regSW state]) {
		[regText setBackgroundColor:[NSColor whiteColor]];
		[regText setEnabled:YES];
		[caseSW setEnabled:YES];
	}else {
		[regText setBackgroundColor:[NSColor lightGrayColor]];
		[regText setEnabled:NO];
		[caseSW setEnabled:NO];
	}
	[self changeTrav:self];
}

- (void)changeTrav:(id)sender
{
	NSString *title;
	BOOL	st = [travButton state];
	title = (st && [modeSW selectedTag] == m_absolute)
		? NSLocalizedString(@"Target Directory", TargetDir)
		: NSLocalizedString(@"Name of Album", NameOfAlbum);
	[albumTextTitle setStringValue: title];
	[HTMLButton setEnabled:st];
	if (!st)
		[HTMLButton setState:NO];
	[self changeHTML:self];
}

- (void)changeHTML:(id)sender
{
	BOOL st = [HTMLButton state] && [travButton state];
	[HTMLinterlace setEnabled:st];
	[HTMLnoFilename setEnabled:st];
	[HTMLnoSizeinfo setEnabled:st];
}

- (BOOL *)HTMLsetting
{
	return isHTML ? HTMLvals : NULL;
}

- (void)doit:sender
{
	NSString *filename, *dirname, *sb;
	BOOL	travDirs, isdir = NO;
	NSFileManager *manager;

	travDirs = [travButton state];
	thumbsz = [thumbSliders currentSize];
	[regx release];
	regx = nil;
	colnum = [widthText intValue];
	relmod = [modeSW selectedTag];
	isHTML = [HTMLButton state];
	HTMLvals[HTML_interlace] = [HTMLinterlace state];
	HTMLvals[HTML_nofilename] = [HTMLnoFilename state];
	HTMLvals[HTML_nosizeinfo] = [HTMLnoSizeinfo state];
	incflag = [thePreference includeAlbumFiles];

	dirname = [directoryText stringValue];
	if (!dirname || [dirname length] == 0) {
		[ErrAlert runAlert:nil : Err_NODIR_NAME];
		return;
	}
	manager = [NSFileManager defaultManager];
	if (![manager fileExistsAtPath:dirname isDirectory:&isdir] || !isdir) {
		[ErrAlert runAlert:dirname : Err_NODIR];
		return;
	}
	filename = [albumText stringValue];
	if (filename && [filename length] == 0)
		filename = nil;
	if (relmod == m_absolute) { /* Absolute */
		if ((!filename && travDirs)
		|| (filename && ![filename isAbsolutePath])) {
			[ErrAlert runAlert:filename : Err_ALB_USEABS];
			return;
		}
		if (filename) {
			sb = [filename stringByDeletingLastPathComponent];
			if (![manager isWritableFileAtPath:sb]) {
				[ErrAlert runAlert:sb : Err_SAVE];
				return;
			}
		}
	}else {
		if (filename && [filename isAbsolutePath]) {
			[ErrAlert runAlert:filename : Err_ALB_ABSPATH];
			return;
		}
		if (relmod == m_relative && filename == nil) {
			filename = [thePreference defaultAlbumName];
			if (filename == nil) {
				[ErrAlert runAlert:nil : Err_NOALB_NAME];
				return;
			}
			[albumText setStringValue:filename];
		}
	}
	if ([regSW state]) {
		NSString *str = [regText stringValue];
		if (str && [str length] > 0)
			regx = [[Regexp alloc] initExpression:str];
		if (regx == nil) {
			[ErrAlert runAlert:dirname : Err_REGEXP];
			return;
		}
	}

	[infoPanel saveFrameUsingName:NewDocWindowName];
	[infoPanel close];

	[newNamePath release];
	newNamePath = [filename retain];
	/* newNamePath must have effective path before "makeAlbumIn:" */
	if (travDirs) {
		id trav = [[DirTravCtrl alloc] initWithMaker:self];
		traversing = YES;
		[trav activateTrav:dirname];
		[targetPath release];
		targetPath = [dirname retain];
	}else
		(void)[self makeAlbumIn:dirname newName:newNamePath];
}

- (void)cancelit:sender
{
	[infoPanel saveFrameUsingName:NewDocWindowName];
	[infoPanel close];
}

- (void)traverseFinished
{
	traversing = NO;
}


/* Dragging */
- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender
{
	NSPasteboard *pboard;
	unsigned int sourceDragMask;

	sourceDragMask = [sender draggingSourceOperationMask];
	pboard = [sender draggingPasteboard];

	if ([[pboard types] indexOfObject:NSFilenamesPboardType] != NSNotFound
		&& (sourceDragMask & NSDragOperationCopy)) {
			return NSDragOperationCopy;
	}
	return NSDragOperationNone;
}

- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender
{
	return YES;
}

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender
{
	NSPasteboard *pboard;
	NSString *dirname;
	BOOL	isdir;
	id	prop = nil;

	pboard = [sender draggingPasteboard];
	if ([[pboard types] indexOfObject:NSFilenamesPboardType] == NSNotFound)
			return NO;
	prop = [pboard propertyListForType:NSFilenamesPboardType];
	if ([prop isKindOfClass:[NSArray class]])
		dirname = [prop objectAtIndex:0];
	else if ([prop isKindOfClass:[NSString class]])
		dirname = prop;
	else
		return NO;
	if (![[NSFileManager defaultManager]
		fileExistsAtPath:dirname isDirectory:&isdir])
		return NO;
	if (!isdir)
		dirname = [dirname stringByDeletingLastPathComponent];
	[directoryText setStringValue:dirname];
	return YES;
}

@end
