#import <AppKit/AppKit.h>
#import <AppKit/NSDragging.h>
#import "../TACommon.h"

#undef WITH_SORT_SW

@class Regexp;

@interface TADocMaker : NSObject
{
	id	infoPanel;
	id	directoryText;
	id	regText;
	id	regSW;
	id	caseSW;
	id	albumText;
	id	albumTextTitle;
	id	albumButton;
	id	travButton;
	id	modeSW;
	id	modeText;
	id	widthText;
	id	thumbSliders;
	id	HTMLButton;
	id	HTMLinterlace;
	id	HTMLnoFilename;
	id	HTMLnoSizeinfo;
	Regexp	*regx;
	NSSize	thumbsz;
	int	colnum;
	int	relmod;
	NSString *newNamePath;
	NSString *targetPath;
	BOOL	traversing;
	BOOL	incflag;
	BOOL	isHTML;
	BOOL	HTMLvals[HTML_BOOLS];
}

+ (void)setLastOpenedDirectory:(NSString *)dir;
+ (NSString *)lastOpenedDirectory;
+ (id)defaultDocMaker;
- (id)init;
- (void)dealloc;
- (void)makeNewDocument:sender;
- (BOOL)makeNewDocumentWith:(NSString *)fname;
- (void)referDirectory:sender;
- (void)changeMode:sender;
- (void)changeTrav:(id)sender;
- (void)changeHTML:(id)sender;
- (BOOL *)HTMLsetting;
- (void)doit:sender;
- (void)cancelit:sender;
- (void)traverseFinished;

/* Dragging */
- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender;
- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender;
- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender;

@end

@interface TADocMaker (MakeCtrl)

- (BOOL)makeAlbumIn:(NSString *)dirname newName:(NSString *)newName;
- (BOOL)makeAlbumFor:(NSString *)travdir;
- (void)saveNewDoc:(id)newdoc;

@end
