#import "DirTravCtrl.h"
#import <Foundation/NSString.h>
#import <Foundation/NSNotification.h>
#import "TADocMaker.h"
#import "DirTraverser.h"
#import "../TACommon.h"
#import "../TAController.h"
#import "../TADocument.h"

#define  TravWindowName	@"Traverse"

@implementation DirTravCtrl

- (id)initWithMaker:(id)obj
{
	[super init];
	rootDir = currentDir = nil;
	dirtrav = nil;
	maker = obj;
	isWaiting = isAuto = NO;
	currentDoc = nil;
	HTMLsetting = [maker HTMLsetting];
	[[NSNotificationCenter defaultCenter] addObserver:self
		selector:@selector(albumBuilt:)
		name:AlbumDidBuild object:nil];
	return self;
}

- (void)dealloc
{
	[rootDir release];
	[dirtrav release];
	[currentDir release];
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	[super dealloc];
}

/* Local Method */
- (void)showCurrentDir
{
	NSString *w;
	if ([currentDir length] <= rootDirLength)
		w = @".";
	else
		w = [currentDir substringFromIndex:rootDirLength];
	[currentDirTX setStringValue:w];
}

- (BOOL)activateTrav:(NSString *)filename
{
	dirtrav = [[DirTraverser alloc] initWithPath:filename];
	if (dirtrav == nil) {
		[self release];
		return NO;
	}
	[NSBundle loadNibNamed:@"DirTraverse.nib" owner:self];
	[panel setFloatingPanel:YES];
	[panel setFrameUsingName:TravWindowName];
	[panel makeKeyAndOrderFront:self];

	[nextButton setEnabled:YES];
	[skipButton setEnabled:YES];
	[autoButton setEnabled:YES];
	[quitButton setEnabled:YES];

	rootDir = [filename retain];
	[rootDirTX setStringValue:rootDir];
	rootDirLength = [rootDir length];
	if ([rootDir characterAtIndex:(rootDirLength-1)] != '/')
		rootDirLength++;
	currentDir = [[dirtrav nextPath] retain];
	[self showCurrentDir];
	return YES;
}

/* Local Method */
- (void)closeCurrentDoc
{
	if (currentDoc) {
		if ([theController checkWindow:currentDoc delete:NO]) {
			id win = [currentDoc window];
			[win makeKeyAndOrderFront:self];
			[win performClose:self];
		}
		currentDoc = nil;
	}
}

/* Local Method */
- (void)gonext
{
	if (currentDir == nil) { /* End of Traverse */
		[currentDirTX setStringValue:@"(none)"];
		[nextButton setEnabled:NO];
		[skipButton setEnabled:NO];
		[autoButton setEnabled:NO];
		[quitButton setEnabled:YES];  /* Click "Quit" to exit */
		[panel makeKeyAndOrderFront:self];
		return;
	}
	[self showCurrentDir];
	if (isAuto) {
		[self performSelector:@selector(makeNextAlbum:) 
			withObject:self afterDelay: 30 / 1000.0];
	}else {
		[nextButton setEnabled:YES];
		[skipButton setEnabled:YES];
	}
}

- (void)albumBuilt:(NSNotification *)aNotification
/* This method catches notification 'AlbumDidBuild' from AlbumCtr */
{
	/* Even if notifications came repeatedly, currentDir isn't changed */
	if (!isWaiting)
		return;

	isWaiting = NO;
	/* This state is set by previous "makeNextAlbum:" */
	currentDoc = [aNotification object];
	if (currentDoc && [theController checkWindow:currentDoc delete:NO])
		[maker saveNewDoc:currentDoc];
	[self gonext];
}

- (void)makeNextAlbum:(id)sender
{
	NSString *tmp;

	[self closeCurrentDoc];
	tmp = currentDir;
	[currentDir autorelease];
	currentDir = [[dirtrav nextPath] retain];
	isWaiting = YES;
	[nextButton setEnabled:NO];
	[skipButton setEnabled:NO];
	/* This state is reset by call of "albumBuilt:" */
	if (![maker makeAlbumFor:tmp]) { /* Error */
		isWaiting = NO;
		[self gonext];
	}
}

- (void)skipNextAlbum:(id)sender
{
	[self closeCurrentDoc];
	[currentDir release];
	currentDir = [[dirtrav nextPath] retain];
	[self gonext];
}

- (void)makeAutomatic:(id)sender
{
	[self closeCurrentDoc];
	isAuto = !isAuto;
	if (isAuto && !isWaiting)
		[self makeNextAlbum:sender];
}

- (void)stopAll:(id)sender
{
	// isAuto = NO;
	[NSObject cancelPreviousPerformRequestsWithTarget:self
			selector:@selector(makeNextAlbum:) object:self];
	[panel setDelegate:nil];
	[panel saveFrameUsingName:TravWindowName];
	[panel close];
	[maker traverseFinished];
	[self release];
}

@end
