#import "ImageInfoNode.h"
#import <Foundation/NSArray.h>
#import <Foundation/NSString.h>
#import <Foundation/NSBundle.h>		/* mainBundle */
#import <AppKit/NSImage.h>
#import <AppKit/NSPasteboard.h>
#import <AppKit/NSWorkspace.h>
#import <stdio.h>
#import <sys/types.h>
#import <sys/stat.h>
#import <sys/file.h>
#import "TACommon.h"
#import "imagefunc.h"
#import "BundleLoader.h"
#import "Shrinker.bproj/ImageShrinker.h"

@implementation ImageInfoNode

static NSImage *img_none, *img_dmy, *img_alb, *img_html;
static ImageShrinker *shrinker = nil;

+ (void)initialize
{
	static BOOL tooLate = NO;
	NSBundle *bundle;

	if (tooLate)
		return;
	tooLate = YES;
	bundle = [NSBundle mainBundle];
	img_none = [NSImage allocWithZone:[self zone]];
	[img_none initByReferencingFile:
		[bundle pathForResource:@"TAnone" ofType:@"tiff"]];
	img_dmy = [NSImage allocWithZone:[self zone]];
	[img_dmy initByReferencingFile:
		[bundle pathForResource:@"TAdummy" ofType:@"tiff"]];
	img_alb = [NSImage allocWithZone:[self zone]];
	[img_alb initByReferencingFile:
		[bundle pathForResource:@"TAdoc" ofType:@"tiff"]];
	img_html = [NSImage allocWithZone:[self zone]];
	[img_html initByReferencingFile:
		[bundle pathForResource:@"TAhtml" ofType:@"tiff"]];
}

- (id)init
{
	[super init];
	filename = iconname = comment = titlename = nil;
	image = nil;
	width = height = size = 0;
	thsize.width = thsize.height = 0.0;
	absolute = NO;
	return self;
}

- (void)dealloc
{
	if (filename) [filename release];
	if (iconname) [iconname release];
	if (comment) [comment release];
	if (titlename) [titlename release];
	if (image) [image release];
	[super dealloc];
}

- (id)copy
{
	ImageInfoNode *cp = [[[self class] alloc] init];
	cp->filename = [filename retain];
	cp->comment = [comment retain];
	cp->iconname = [iconname retain];
	cp->titlename = [titlename retain];
	/* iconname & titlename are effective only in the original Album */
	cp->image = [image retain];
	cp->width = width;
	cp->height = height;
	cp->size = size;
	cp->thsize = thsize;
	cp->absolute = absolute;
	cp->origDocSN = origDocSN;
	return cp;
}

- (void)setFilename:(NSString *)name {
	if (filename) [filename release];
	filename = [name retain];
}
- (void)setIconname:(NSString *)name {
	if (iconname) [iconname release];
	iconname = [name retain];
}
- (void)setComment:(NSString *)str {
	if (comment) [comment release];
	comment = (str && [str length] > 0) ? [str retain] : nil;
}
- (void)setTitlename:(NSString *)name
{
	if (titlename) [titlename release];
	titlename = [name retain];
}
- (NSString *)filename { return filename; }
- (NSString *)iconname { return iconname; }
- (NSString *)comment { return comment; }
- (NSString *)titlename { return titlename; }
- (NSImage *)image { return image; }
- (BOOL)isAbsolute { return absolute; }
- (void)setAbsolute:(BOOL)flag { absolute = flag; }

static char *GMKdigit(long size)
{
	int	i, j, w;
	char tmp[32];
	static char buf[32];

	sprintf(tmp, "%ld", size);
	i = strlen(tmp);
	w = i % 3;
	if (w == 0) w = 3;
	for (i = j = 0; ; ) {
		if (--w == 0) {
			buf[i++] = tmp[j++];
			if (tmp[j] == 0) {
				buf[i] = 0;
				break;
			}
			buf[i++] = ',';
			w = 3;
		}else
			buf[i++] = tmp[j++];
	}
	return buf;
}

- (NSString *)sizeString
{
	const char *kb;
	long	sz;

	if ((sz = size) >= 10240) {	/* >= 10KB ? */
		sz /= 1024;
		if (sz >= 1024) {	/* >= 1MB ? */
			sz /= 1024;
			kb = "MB";
		}else
			kb = "KB";
	}else
		kb = "bytes";
	if (width > 0 && height > 0)
		return [NSString stringWithFormat: @"%dx%d (%s%s)",
			(int)width, (int)height, GMKdigit(sz), kb];
	return [NSString stringWithFormat: @"%s%s", GMKdigit(sz), kb];
}

/* Local Method */
- (NSImage *)getImageFromWS:(BOOL)exist
{
	NSImage *img;
	id ws = [NSWorkspace sharedWorkspace];
	img =  exist ? [ws iconForFile:filename]
			: [ws iconForFileType: [filename pathExtension]];
	[img retain];
	return img;
}

- (NSImage *)setIconImage
{
/*
	If filename is not given, it is a dummy button.
	If the image file can't be opened, "img_none" is displayed.
*/
	struct stat	buf;
	NSString	*sfx;
	BOOL	exist = YES, isdir = NO;
	id rep;

	if (image)
		return image;
	if (filename == nil) {
		[(image = img_dmy) retain];
		return image;
	}
	if (stat([filename cString], &buf) == 0) {
		size = (long)buf.st_size;
		isdir = (buf.st_mode & S_IFDIR) != 0;
	}else
		exist = NO;
	sfx = [filename pathExtension];
	if (isdir) {
		if ([sfx isEqualToString: Suffix])
			[(image = img_alb) retain];
		else if ([sfx isEqualToString: HTMLDirSuffix])
			[(image = img_html) retain];
		else
			image = [self getImageFromWS:YES];
		return image;
	}
	if (iconname != nil) {
		image = [NSImage allocWithZone:[self zone]];
		[image initByReferencingFile: iconname];
	}else if (exist) {
		NSSize	sz;
		image = [NSImage allocWithZone:[self zone]];
		if ([sfx caseInsensitiveCompare:@"bmp"] == NSOrderedSame
		|| [sfx caseInsensitiveCompare:@"dib"] == NSOrderedSame) {
		/* Because bmp-image routines of OPENSTEP 4.1 is not good */
			NSPasteboard *pb;
			id arr;
			pb = [NSPasteboard pasteboardByFilteringFile:filename];
			arr = [pb types];
			[image initWithPasteboard: pb];
		}else
			[image initByReferencingFile: filename];
		sz = [image size];
		width = sz.width;
		height = sz.height;
	}
	if (image != nil && [image isValid]) {
		NSSize imsz;
		int dim = (thsize.width > thsize.height)
			? thsize.width : thsize.height;
		rep = [image bestRepresentationForDevice:nil];
		imsz = getImageSize(image);
		if (imsz.width > dim || imsz.height > dim) {
			if (shrinker == nil)
				shrinker = [[BundleLoader loadClass:b_Shrinker] alloc];
			[shrinker initWidth:dim height:dim];
			image = [shrinker shrinkedImage:image size:imsz];
		}
	}else {
		if (image != nil)
			[image release];
		image = [self getImageFromWS:exist];
		if (iconname != nil)
			[iconname release];
		iconname = nil;
	}
	return image;
}

- (void)setIconImageDirectly:(NSImage *)img
{
	[image release];
	image = img;
	[image retain];
}

- (void)setWidth:(int)wid height:(int)hei size:(long)sz
{
	width = (int)wid;
	height = (int)hei;
	size = (long)sz;
}
- (int)width  {	return (int)width; }
- (int)height {	return (int)height; }
- (long)size  {	return size; }
- (int)origDocSN { return origDocSN; }
- (void)setOrigDocSN:(int)number { origDocSN = number; }
- (NSSize)thumbSize { return thsize; }
- (void)setThumbSize:(NSSize)sz { thsize = sz; }

@end
