#import <AppKit/AppKit.h>

@class NSImage;

@interface ImageInfoNode : NSObject
{
	NSString  *filename;
	NSString  *iconname;
	NSString  *comment;
	NSString  *titlename;
	NSImage   *image;
	short	width, height;
	long	size;
	NSSize	thsize;		/* size of thumbnails */
	BOOL	absolute;
	short	origDocSN;	/* Serial numver of original doc. */
				/* This is used only when Copy & Paste */
}

+ (void)initialize;
- (id)init;
- (void)dealloc;
- (id)copy;
- (void)setFilename:(NSString *)name;
- (void)setIconname:(NSString *)name;
- (void)setComment:(NSString *)str;
- (void)setTitlename:(NSString *)name;
- (NSString *)filename;
- (NSString *)iconname;
- (NSString *)comment;
- (NSString *)titlename;
- (NSString *)sizeString;
- (NSImage *)image;
- (NSImage *)setIconImage;
- (void)setIconImageDirectly:(NSImage *)img;
- (void)setWidth:(int)wid height:(int)hei size:(long)sz;
- (int)width;
- (int)height;
- (long)size;
- (BOOL)isAbsolute;
- (void)setAbsolute:(BOOL)flag;
- (int)origDocSN;
- (void)setOrigDocSN:(int)number;
- (NSSize)thumbSize;
- (void)setThumbSize:(NSSize)sz;

@end


/**** Example
# 5
P "/usr/local/lib/image/beauty.tiff"
I "beauty.tiff"
S 640 480 32011
C Sleeping Beauty
P "/home/tomoc/image/kids.gif"
I "kids.tiff"
S 400 256 19031
; comment
X ------ empty
****/
