#import "EditCtr.h"
#import "AlbumCtr.h"
#import "TADocument.h"
#import "TAController.h"

#define  EditWindowName	@"EditTool"
/* Global */
EditCtr *theEditCtr = nil;

@implementation EditCtr

- (id)init
{
	[super init];
	insertMode = P_Insert;
	[pasteCount setIntValue:0];
	theEditCtr = self;
	return self;
}

- (void)makeKeyAndOrderFront:(id)sender
{
	[panel setFrameUsingName:EditWindowName];
	[panel makeKeyAndOrderFront:sender];
}

- (void)setInsertMode:sender
{
	int	mode = [sender tag] ? P_Add : P_Insert;
	insertMode = mode;
	[insertModeButton setState:mode];
}

- (void)changeInsertMode:sender
{
	int	mode = [sender state] ? P_Add : P_Insert;
	insertMode = mode;
}

- (int)insertMode
{
	return insertMode;
}

- (void)showCount:(int)count
{
	[pasteCount setIntValue:count];
}

- (void)clearPasteboard:sender
{
	[AlbumCtr clearPasteboard];
	// [pasteCount setIntValue:0];
}

- (void)changeWidth:sender
{
	id	doc;

	if ((doc = [theController keyWindow]) == nil)
		NSBeep();
	else if (![doc changeWidthBy:([sender tag] ? (-1) : 1)])
		NSBeep();
}

/* delegate methods */
- (BOOL)windowShouldClose:(id)sender
{
	[panel saveFrameUsingName:EditWindowName];
	return YES;
}

@end

