#import "AlbumCtr.h"
#import <AppKit/NSApplication.h>
#import <AppKit/NSGraphics.h>
#import <AppKit/NSMatrix.h>
#import <AppKit/NSPasteboard.h>
#import <Foundation/NSBundle.h>		/* LocalizedString */
#import <Foundation/NSFileManager.h>
#import <Foundation/NSArray.h>
#import <libc.h>
#import "TACommon.h"
#import "TADocument.h"
#import "EditCtr.h"
#import "PhotoCell.h"
#import "ImageInfoNode.h"
#import "PrefControl.h"
#import "AlertShower.h"

/* Local */
static id pbinfo;	/* pasteboard of info */


@implementation AlbumCtr (Editing)

+ (void)clearPasteboard
{
	[pbinfo release];
	pbinfo = [[NSMutableArray alloc] initWithCapacity:1];
	[theEditCtr showCount: 0];
}

- (void)setDocumentEdited:(BOOL)flag
{
	[window setDocumentEdited: flag];
}

- (BOOL)isDocumentEdited
{
	return [window isDocumentEdited];
}

- (void)changeColumns
{
	NSRect rect;

	row = [tadoc rows];
	col = [tadoc columns];
	[albumview renewRows:row columns:col];
	[albumview sizeToCells];
	[self setInfoToCell];
	[albumview setNeedsDisplay:YES];
	[self setDocumentEdited:YES];
	rect = [albumview frame];
	[self locateWindow:rect.size.width :rect.size.height by:loc_RESZ:NULL];
}

- (void)setThumbnailSize:(NSSize)size
{
	NSRect rect;
	NSSize protoSize;
	int	i, j;

	protoSize.width = thwidth = size.width + M_Width;
	protoSize.height = thheight = size.height + M_Height;
	[albumview setCellSize: protoSize];
	[albumview sizeToCells];
	[scrollview setLineScroll:(thheight + IntrCellSpc)];
	[albumview setNeedsDisplay:YES];
	[self setDocumentEdited:YES];
	for (i = 0; i < row; i++)
		for (j = 0; j < col; j++) {
			id cell = [albumview cellAtRow:i column:j];
			rect = [albumview cellFrameAtRow:i column:j];
			[cell showIconImage];
			// [albumview displayRect:rect];
		}
	[albumview display];
	rect = [albumview frame];
	[self locateWindow:rect.size.width :rect.size.height by:loc_RESZ:NULL];
}


/* local method */
- (NSPasteboard *)generalPb
{
	static NSArray *pbtypes = nil;
	NSPasteboard *pb;

	if (!pbtypes) {
		pbtypes = [NSArray arrayWithObject:NSStringPboardType];
		[pbtypes retain];
	}
	pb = [NSPasteboard generalPasteboard];
	[pb declareTypes:pbtypes owner:nil];
	return pb;
}


static PhotoCell *theCell;

/* delegate methods */
- (void)copy:(id)sender
{
	PhotoCell *cel;
	NSString *fnam;
	ImageInfoNode *node;

	theCell = nil;
	if ((cel = [albumview selectedCell]) == nil) {
		NSBeep();
		return;
	}
	if ((fnam = [cel filename]) != nil)
		[[self generalPb] setString:fnam forType:NSStringPboardType];
	theCell = cel;
	node = [cel info];
	[node setOrigDocSN:[tadoc serialNumber]];
	[pbinfo insertObject:node atIndex:0];
	[theEditCtr showCount: [pbinfo count]];
}


/* Local Method */
- (void)redisplay
{
	NSRect	rect;
	int	i, j, newrow;
	int	selr;

	newrow = [tadoc rows];
	selr = [albumview selectedRow];
	if (newrow == row) {
		[self setInfoToCell];
	}else {
		row = newrow;
		[albumview renewRows:row columns:col];
		[albumview sizeToCells];
		[self setInfoToCell];
		rect = [albumview frame];
		[self locateWindow:rect.size.width :rect.size.height
			by:loc_RESZ:NULL];
	}
	for (i = selr; i < row; i++)
		for (j = 0; j < col; j++) {
			id cell = [albumview cellAtRow:i column:j];
			rect = [albumview cellFrameAtRow:i column:j];
			[cell showIconImage];
			[albumview displayRect:rect];
		}
	[albumview display];
}

/* Local Method */
- (void)removeWithCopy:(BOOL)withCopy
{
	int	selc, selr;
	PhotoCell	*cel = nil;

	selr = [albumview selectedRow];
	selc = [albumview selectedColumn];
	if (withCopy) {
		[self copy:self];
		if (theCell)
			cel = theCell;
	}else
		cel = [albumview selectedCell];
	if (!cel || ![tadoc removeImageInfoOf:cel]) {
		NSBeep();
		return;
	}

	[self redisplay];
	if (![tadoc imageInfoAtRow:selr column:selc]) {
		if (--selc < 0) {
			if (--selr >= 0)
				selc = col - 1;
			else
				selr = selc = 0;
		}
	}
	[albumview selectCellAtRow:selr column:selc];
	[self clickAct:albumview];
	[self setDocumentEdited:YES];
}

/* delegate methods */
- (void)cut:(id)sender
{
	[self removeWithCopy:YES];
}

/* delegate methods */
- (void)delete:(id)sender
{
	if ([sender tag] > 0) {
		NSString *fnam, *mesg, *syes, *sccl;
		int	ans;

		fnam = [[[albumview selectedCell] info] filename];
		if (fnam == nil || [fnam length] == 0) {
			NSBeep();
			return;
		}
		syes = NSLocalizedString(@"Yes", YES);
		sccl = NSLocalizedString(@"Cancel", CANCEL);
		mesg = NSLocalizedString(@"Remove File?", RemoveFile);
		ans = NSRunAlertPanel(@"", @"%@\n%@",
			syes, sccl, nil, fnam, mesg);
		if (ans != NSAlertDefaultReturn)
			return;
		if (unlink([fnam cString]) != 0) {
			[ErrAlert runAlert:fnam :Err_ACCESS];
			return;
		}
	}
	[self removeWithCopy:NO];
}

/* delegate methods */
- (void)paste:(id)sender
{
	PhotoCell *cel;
	ImageInfoNode *node = nil;
	int	mode, tag, selc, selr;

	selr = [albumview selectedRow];
	selc = [albumview selectedColumn];
	tag = [sender tag];
	mode = [theEditCtr insertMode];
	cel = [albumview selectedCell];
	if (tag == P_Empty) {
		node = [[ImageInfoNode alloc] init];
		[node autorelease];
		[node setThumbSize:[tadoc thumbSize]];
	}else {
		if ([pbinfo count] <= 0) {
			NSBeep();
			return;
		}
		node = [pbinfo objectAtIndex:0];
		if ([node origDocSN] != [tadoc serialNumber]) {
			node = [[node copy] autorelease];
			[node setIconname:nil];
			[node setTitlename:nil];
/***** If the size of thumbnails are different, we should remake them... *****/
		}
	}
	if (![tadoc pasteImageInfo:node at:cel mode:mode]) {
		NSBeep();
		return;
	}
	if (tag != P_Empty) {
		[pbinfo removeObjectAtIndex:0];
		[theEditCtr showCount: [pbinfo count]];
	}

	[self redisplay];
	if (mode == P_Add) {
		if (++selc >= col) {
			++selr;
			selc = 0;
		}
	}
	[albumview selectCellAtRow:selr column:selc];
	[self clickAct:albumview];
	[self setDocumentEdited:YES];
}


/* Dragging */
- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender
{
	NSPasteboard *pboard;
	unsigned int sourceDragMask;

	sourceDragMask = [sender draggingSourceOperationMask];
	pboard = [sender draggingPasteboard];

	if ([[pboard types] indexOfObject:NSFilenamesPboardType] != NSNotFound
		&& (sourceDragMask & NSDragOperationCopy)) {
			return NSDragOperationCopy;
	}
	return NSDragOperationNone;
}

- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender
{
	return YES;
}

/* Local Method */
- (void)doDragOperation:(id)prop
{
	ImageInfoNode *node = nil;
	PhotoCell *cel;
	NSString *fname;
	BOOL	isAlbum, isdir;
	int	idx, mode, num, selc, selr, lev, rel;
	NSSize	thsz;
	NSAutoreleasePool *subpool;
	NSFileManager *manager = [NSFileManager defaultManager];

	selr = [albumview selectedRow];
	selc = [albumview selectedColumn];
	mode = [theEditCtr insertMode];
	thsz = [tadoc thumbSize];
	rel = [tadoc documentMode];
	num = 0;
	for (idx = [prop count] - 1; idx >= 0; --idx) {
		fname = [prop objectAtIndex:idx];
		isdir = isAlbum = NO;
		if (![manager fileExistsAtPath:fname isDirectory:&isdir])
			continue;

		subpool = [[NSAutoreleasePool alloc] init];
		if (isdir)
			isAlbum = ([TADocument isAlbumPath:fname] != A_None);

		node = [[ImageInfoNode alloc] init];
		[node autorelease];
		[node setThumbSize: thsz];
		[node setFilename:fname];
		if (isAlbum) {
			NSString *t =[tadoc pathRelativeToAlbum:fname];
			if (t) [node setTitlename:t];
		}
		if (rel == m_absolute ||
			(lev = [tadoc levelOfSubDirectory:fname]) <= 0)
			[node setAbsolute:YES];
		else if (lev == 2 && rel == m_relative)
			[node setTitlename: [tadoc pathRelativeToAlbum:fname]];
		cel = [albumview selectedCell];
		[tadoc pasteImageInfo:node at:cel mode:mode];
		[self redisplay];
		/* Don't move current point as 'paste' does */
		[albumview selectCellAtRow:selr column:selc];
		[self clickAct:albumview];
		num++;

		[subpool release];
	}
	if (num > 0)
		[self setDocumentEdited: YES];
}

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender
{
	NSPasteboard *pboard;
	id	prop = nil;

	pboard = [sender draggingPasteboard];
	if ([[pboard types] indexOfObject:NSFilenamesPboardType] == NSNotFound)
			return NO;
	prop = [pboard propertyListForType:NSFilenamesPboardType];
	if ([prop isKindOfClass:[NSArray class]]) {
		if ([prop count] <= 0)
			return NO;
		if ([thePreference defaultSorting] == Sort_NameC)
			/* Sort by Name : case sensitive */
			prop = [prop sortedArrayUsingSelector:
				@selector(compare:)];
		else	/* Sort by Name : case insensitive  */
			prop = [prop sortedArrayUsingSelector:
				@selector(caseInsensitiveCompare:)];
	}else if ([prop isKindOfClass:[NSString class]])
		prop = [NSArray arrayWithObject:prop];
	else
		return NO;
	[self performSelector:@selector(doDragOperation:) 
		withObject:prop afterDelay: 30 / 1000.0];
		// Note: prop is retain'ed by this calling.
	return YES;
}

@end
