#import <AppKit/AppKit.h>
#import <AppKit/NSDragging.h>
#import "TADocument.h"

/* Consts used by method "locateWindow::by::" */
#define  loc_INIT	0	/* Window is initialized */
#define  loc_RESZ	1	/* Window is resized */
#define  loc_SPEC	2	/* Window is initialized */
				/* and displayed at specified point */
#define  IntrCellSpc	1.0

@class ImageInfoNode;

@interface AlbumCtr : NSObject
{
	id	scrollview;
	id	window;
	id	tadoc;
	id	pathText;
	id	sizeText;
	id	memoText;
	id	stopButton;
	NSMatrix *albumview;
	int	row;
	int	col;
	short	thwidth;
	short	thheight;
	BOOL	isNew;
	BOOL	inLoop;
}

+ (void)initialize;
- (void)setInfoToCell;
- (id)init:(id)doc withName:(NSString *)fileName;
- (void)dealloc;
- locateWindow: (int)width : (int)height by:(int)is_init : (NSPoint *)atpoint;
- locateWindow;
- (NSString *)displayMessage:(NSString *)msg;
- (id)window;
- (id)view;
- (void)setIsNew:(BOOL)flag;
- (BOOL)isNew;
- (void)changeCellFont:(NSNotification *)aNotification;
- (void)changeTitleSuffix:(NSNotification *)aNotification;
- (void)print: sender;
- (ImageInfoNode *)selectedCellInfo;
- (void)memoChange:sender;
- (void)confirmAndClose:(id)sender;

/* Action */
- (void)clickAct:sender;
- (void)doubleClickAct:sender;

/* delegate methods */
- (BOOL)windowShouldClose:(id)sender;
- (void)windowDidBecomeMain:(NSNotification *)aNotification;

@end

@interface AlbumCtr (Editing)

+ (void)clearPasteboard;
- (void)setDocumentEdited:(BOOL)flag;
- (BOOL)isDocumentEdited;
- (void)changeColumns;

- (void)copy:(id)sender;
- (void)cut:(id)sender;
- (void)paste:(id)sender;
- (void)delete:(id)sender;

- (void)setThumbnailSize:(NSSize)size;

/* Dragging */
- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender;
- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender;
- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender;

@end
