/*
OpenBase MOVIE LOOKUP - Java example using the OpenBase JDBC Driver 
		   Copyright (c) 1998 OpenBase International Ltd. 
		                All Rights Reserved.
*/

import java.sql.*;
import java.awt.*;
import java.io.*;


public class myWindow extends Frame
{
	private	Connection		connection;
	private boolean			alreadyDone = false;
	private String			driver, URL, login, pwd;
	private TextArea		resultTA, sqlTA;
	private TextField 		titleTField;
	private Choice			ratingPP, categoryPP;
	
	public myWindow(String name, demo d)
	{
		driver = "openbase.jdbc.ObDriver";
		URL = "jdbc:openbase://207.44.189.25/Movie";			// get connection's url
		login = "";
		pwd = "";
		
		this.setTitle(name);
		
		try
		{
			Class.forName(driver).newInstance();						// register driver with DriverManage
			connection = DriverManager.getConnection(URL,login,pwd);	// establish connection with server
  		}
		catch( Exception e )
	  	{
	      System.out.println(e.getMessage());
	      e.printStackTrace();
	      //System.out.println(e);
	    }
		
		setBackground(new Color(204,204,153));
		GridBagLayout	gridBag = new GridBagLayout();
		GridBagConstraints	constraints = new GridBagConstraints();
		setLayout(gridBag);
		
	// Movie lookup label
		buildConstraints(constraints, 0, 0, 3, 1, 0,10);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		Label movieLabel = new Label("MOVIE LOOKUP - Java Example", Label.LEFT);
		movieLabel.setFont(new Font("Geneva", Font.BOLD + Font.ITALIC, 30));
		movieLabel.setForeground(Color.blue);
		gridBag.setConstraints(	movieLabel, constraints);
		add(movieLabel);
	
	// Title of the movie label
		buildConstraints(constraints, 0, 1, 1, 1, 20,5);
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.EAST;
		Label titleLabel = new Label("TITLE OF THE MOVIE:", Label.LEFT);
		titleLabel.setFont(new Font("Geneva", Font.BOLD, 12));
		gridBag.setConstraints(	titleLabel, constraints);
		add(titleLabel);

	// TextField of the movie title
		buildConstraints(constraints, 1, 1, 2, 1, 0,0);
		constraints.fill = GridBagConstraints.HORIZONTAL;
		constraints.anchor = GridBagConstraints.WEST;
		titleTField = new TextField();
		gridBag.setConstraints(	titleTField, constraints);
		add(titleTField);
		
	// Rating label
		buildConstraints(constraints, 0, 2, 1, 1, 0,5);
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.EAST;
		Label ratingLabel = new Label("RATING:", Label.LEFT);
		ratingLabel.setFont(new Font("Geneva", Font.BOLD, 12));
		gridBag.setConstraints(	ratingLabel, constraints);
		add(ratingLabel);
		
	// rating popup menu
		buildConstraints(constraints, 1, 2, 1, 1, 20,0);
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.WEST;
		ratingPP = new Choice();
		fullChoice(ratingPP, "SELECT DISTINCT RATING from MOVIE WHERE RATING NOT IN ('', NULL)");
		gridBag.setConstraints(	ratingPP, constraints);
		add(ratingPP);
		
	// Category label
		buildConstraints(constraints, 0, 3, 1, 1, 0,5);
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.EAST;
		Label categoryLabel = new Label("CATEGORY:", Label.LEFT);
		categoryLabel.setFont(new Font("Geneva", Font.BOLD, 12));
		gridBag.setConstraints(	categoryLabel, constraints);
		add(categoryLabel);
		
	// Category popup menu
		buildConstraints(constraints, 1, 3, 1, 1, 0,0);
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.WEST;
		categoryPP = new Choice();
		fullChoice(categoryPP, "SELECT DISTINCT CATEGORY from MOVIE WHERE CATEGORY NOT IN ('', NULL)");
		gridBag.setConstraints(	categoryPP, constraints);
		add(categoryPP);
		
	// Search buttom
		buildConstraints(constraints, 2, 3, 1, 1, 40,0);
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.EAST;
		Button searchButton = new Button("SEARCH");
		gridBag.setConstraints(	searchButton, constraints);
		add(searchButton);
		
	// TextArea of the Results
		buildConstraints(constraints, 0, 4, 3, 1, 0,65);
		constraints.fill = GridBagConstraints.BOTH;
		constraints.anchor = GridBagConstraints.CENTER;
		resultTA = new TextArea();
		//resultTA.setEditable(false);
		gridBag.setConstraints(	resultTA, constraints);
		add(resultTA);
		
	// Info label
		buildConstraints(constraints, 0, 5, 1, 1, 0,5);
		constraints.fill = GridBagConstraints.NONE;
		constraints.anchor = GridBagConstraints.EAST;
		Label infoLabel = new Label("SQL QUERY EXECUTED:", Label.LEFT);
		infoLabel.setFont(new Font("Geneva", Font.BOLD, 12));
		gridBag.setConstraints(	infoLabel, constraints);
		add(infoLabel);	
		
	// TextArea of the SQL Query
		buildConstraints(constraints, 0, 6, 3, 1, 0,15);
		constraints.fill = GridBagConstraints.BOTH;
		constraints.anchor = GridBagConstraints.CENTER;
		//sqlTA = new TextArea("",4, 80, TextArea.SCROLLBARS_VERTICAL_ONLY);
		//sqlTA.setColumns(40);
		sqlTA = new TextArea();
		//sqlTA.setEditable(false);
		gridBag.setConstraints(	sqlTA, constraints);
		add(sqlTA);
	}
	
	public void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx,int wy)
	{
		gbc.gridx = gx;
		gbc.gridy = gy;
		gbc.gridwidth = gw;
		gbc.gridheight = gh;
		gbc.weightx = wx;
		gbc.weighty = wy;
	}

	
	public Insets insets()
	{
		return new Insets(10,10,10,10);
	}		
	
	public void fullChoice(Choice c, String sql)
	{
		String category = "";
		c.addItem("No choice");
		try
		{
			Statement	stmt = connection.createStatement();
			ResultSet	rs = stmt.executeQuery(sql);
			while(rs.next())
	  		{
	  			category =  rs.getString(1);
	  			c.addItem(category);
			}
			stmt.close();
		}
		catch( Exception e )
	  	{
	      System.out.println(e.getMessage());
	      e.printStackTrace();
	      //System.out.println(e);
		}
	}
	
	
	public void performQuery()
	{
		int nbChar = 0, i, nbRows = 0, delta = 0;
		String tmp = "";
		waitThread wt = new waitThread(resultTA);
		Thread thread = new Thread(wt);
		
		
		String sql = "select t0.TITLE, t0.REVENUE, t1.NAME STUDIO from MOVIE t0, STUDIO t1 where t0.STUDIO_ID = t1.STUDIO_ID";
		if (!titleTField.getText().equals(""))
		{
			sql = sql + " AND t0.TITLE LIKE '" + titleTField.getText() + "*'";
		}
		if (!ratingPP.getSelectedItem().equals("No choice"))
		{
			sql = sql + " AND t0.RATING = '" + ratingPP.getSelectedItem() + "'";
		}
		if (!categoryPP.getSelectedItem().equals("No choice"))
		{
			sql = sql + " AND t0.CATEGORY = '" + categoryPP.getSelectedItem() + "'";
		}
		sql = sql + " order by t0.REVENUE DESC";
		
		sqlTA.setText("");
		sqlTA.setText(sql);
		
		String title = "", revenue = "", name = "";
		
		resultTA.setText("");
		resultTA.setFont(new Font("Monaco", Font.BOLD, 12));
	// run the wait animation
		thread.start();
		try
		{
			Statement	stmt = connection.createStatement();
			ResultSet	rs = stmt.executeQuery(sql);
			ResultSetMetaData rsmd = rs.getMetaData();
	  		
	  		//resultTA.setText("");
			for (i = 1; i<= 3; i++)
			{
				if ( rsmd.getColumnName(i).length() < rsmd.getColumnDisplaySize(i) )
				{	
					String deltaStr = "     ";
					delta = rsmd.getColumnDisplaySize(i) - rsmd.getColumnName(i).length();
					for (int j=0; j<delta; j++)
		    		{
		    			deltaStr += " ";
		    		}
		    		tmp += rsmd.getColumnName(i) + deltaStr;
				}
				else
				{
					tmp += rsmd.getColumnName(i) +  "     ";
				}
			// nbChar is the total number of char to display the attributes
				nbChar = 5 + nbChar + rsmd.getColumnDisplaySize(i);
			}
			tmp += "\n";
			for (i = 0; i<nbChar; i++)
			{
				tmp += "-";
			}
			tmp += "\n";
			while(rs.next())
	  		{
	  			nbRows++;
	  			for (i = 1; i<= 3; i++) 
		    	{
		    		String deltaStr = "";
		    		delta = 5 + rsmd.getColumnDisplaySize(i) - rs.getString(i).length();
		    		for (int j=0; j<delta; j++)
		    		{
		    			deltaStr += " ";
		    		}
		    		tmp += rs.getString(i) + deltaStr;
		        }
		        tmp += "\n";
	  			
			}
			
			for (i = 0; i<nbChar; i++)
			{
				tmp += "-";
			}
		// stop the animation
			thread.stop();
			resultTA.setText("");
			resultTA.setFont(new Font("Monaco", Font.PLAIN, 12));
			
			resultTA.appendText(tmp + "\n\n"+ nbRows + " Rows returned\n");
			stmt.close();
		}
		catch( Exception e )
	  	{
	      System.out.println(e.getMessage());
	      e.printStackTrace();
	      //System.out.println(e);
		}
	}
	

	public boolean action (Event evt, Object arg)
	{
		if (evt.target instanceof Button)
		{
			String label = (String)arg;
			if (label.equals("SEARCH"))
			{
				performQuery();
				return true;
			}
		}
		/*if (id == Event.WINDOW_DESTROY)
		{
			System.out.println("destroy the window...");
			this.hide();
		}*/
		return false;
	}



}