/*
	Copyright 1995, Anderson Financial Systems Inc.  All Rights Reserved.
	Anderson Financial Systems, Inc.
	909 Sumneytown Pike, Suite 106
	Springhouse, PA 19477
	215 653 0911
 */
 
/* A border belongs to a style. A style belongs to a paragraph. So by setting 
 * the border you can control the appearance of paragraphs. Paragraphs are also 
 * contained in tables.
 */

@protocol Border

	/* Returns YES if all lines Top, Bottom, Right, Left are equal.
	 */
- (BOOL)areLinesEqual;

	/* Returns the fill color.
	 */
- (NSColor *)fillColor;
- (BOOL)hasFillColor;

	/* Compares a border with anObject that comforms to Border protocol.
	 */
- (BOOL)isEqual:(id <Border>)anObject;

	/* Remove the fill color.
	 */
- removeFillColor;

	/* Sets the fill color.
	 */
- setFillColor:(NSColor *)aColor;

	/* Takes border information from aBorder.
	 */
- takeBorderFrom:(id <Border>)aBorder;

@end

