/* ServiceProvider.m created by tthomas on Mon 06-Dec-1999 */

#import <AppKit/AppKit.h>

#import "ServiceProvider.h"
#import "Generator.h"


@implementation ServiceProvider

/*"
**	This class is created by our AppDelegate and handles all inbound service
**	requests.
"*/

- (void) generateFromTemplate:(NSPasteboard*)pboard userData:(NSString*)userData error:(NSString**)errorStr
/*"
 * This method gets called by the services machinery whenever a service with an
 * NSMessage of generateFromTemplate gets invoked by a user
 * (all the current services entries go through this method). We take the string
 * data off the pasteboard, try and process the service request and put the
 * results back on the pasteboard.
"*/                                                        
{
    NSString* inString = nil;
    NSString* outString = nil;
    BOOL error = NO;

    // Get the inString from the pasteboard.
    if (!error) {
        BOOL hasStringPboardType = [[pboard types] containsObject:NSStringPboardType];
        if (hasStringPboardType) {
            inString = [pboard stringForType:NSStringPboardType];
        }

        if (inString == nil || [inString isEqualToString:@""]) {
            error = YES;
            *errorStr = @"We need variable declarations (as strings) before we "
                @"can generate any accessors.";
        }
    }

    // Generate the outString.
    if (!error) {
        Generator* generator = [Generator generatorWithInput:inString];
        NSDictionary* userDataDict = nil;
        NSString* templateName = nil;
        
        NS_DURING
        userDataDict = [userData propertyList];
        if ([userDataDict isKindOfClass:[NSDictionary class]]) {
            templateName = [userDataDict objectForKey:@"template"];
        }
        NS_HANDLER
            error = YES;
            *errorStr = @"The UserData portion of the service needs to include the template to use in a plist.";
        NS_ENDHANDLER
               
        if (templateName != nil) {
            outString = [generator generateOutputUsingTemplateName:templateName];
            if (outString == nil || [outString isEqualToString:@""]) {
                error = YES;
                *errorStr = @"Could not generate the output.";
            }

        }
    }
    
    // Put the result on the pastboard.
    if (!error) {
        
        [pboard declareTypes:[NSArray arrayWithObject:NSStringPboardType] owner:nil];
        [pboard setString:outString forType:NSStringPboardType];
    }
}

@end
