//
//  _MiscMergeProcedureCommand.m
//            Written by Don Yacktman and Carl Lindberg
//        Copyright 1998 by Don Yacktman and Carl Lindberg.
//                     All rights reserved.
//      This notice may not be removed from this source code.
//
//	This header is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	

#import "_MiscMergeProcedureCommand.h"
#import <Foundation/NSUtilities.h>
#import <Foundation/NSArray.h>
#import "MiscMergeEngine.h"
#import "MiscMergeTemplate.h"
#import "MiscMergeCommandBlock.h"

@implementation _MiscMergeProcedureCommand

- init
{
	[super init];
	commandBlock = [[MiscMergeCommandBlock alloc] initWithOwner:self];
	argumentArray = [[NSMutableArray alloc] init];
	return self;
}

- (void)dealloc
{
	[commandBlock release];
	[procedureName release];
	[argumentArray release];
	[super dealloc];
}

- (NSString *)procedureName
{
	return procedureName;
}

- (BOOL)parseFromScanner:(NSScanner *)aScanner template:(MiscMergeTemplate *)template
{
	NSString *argName;

	[self eatKeyWord:@"procedure" fromScanner:aScanner isOptional:NO];
	procedureName = [[self getArgumentStringFromScanner:aScanner toEnd:NO] retain];

	while (argName = [self getArgumentStringFromScanner:aScanner toEnd:NO])
	{
		[argumentArray addObject:argName];
	}

	[template pushCommandBlock:commandBlock];

	return YES;
}

- (void)handleEndProcedureInTemplate:(MiscMergeTemplate *)template
{
	[template popCommandBlock:commandBlock];
}

- (void)executeForMerge:(MiscMergeEngine *)aMerger
{
	/* Just want to register ourselves to the engine */
	NSString *symbolName = [NSString stringWithFormat:@"_MiscMergeProcedure%@", procedureName];
	[[aMerger userInfo] setObject:self forKey:symbolName];
}

/* The *real* execute; messaged from the call command */
- (void)executeForMerge:(MiscMergeEngine *)aMerger arguments:(NSArray *)passedArgArray
{
	int i, count = [argumentArray count];
	NSMutableDictionary *procedureContext = [NSMutableDictionary dictionary];
	
	if (count != [passedArgArray count])
	{
		NSLog(@"%@: Wrong number of arguments passed (got %d, expected %d)",
				[self class], [passedArgArray count], count);
//		count = MIN(count, [passedArgArray count]); // should I just return or abort?
	}
	
	for (i=0; i<count; i++)
	{
		NSString *argName  = [argumentArray objectAtIndex:i];
		id        argValue = [passedArgArray objectAtIndex:i];
		[procedureContext setObject:argValue forKey:argName];
	}
	
	[aMerger addContextObject:procedureContext];
	[aMerger executeCommandBlock:commandBlock];
	[aMerger removeContextObject:procedureContext];
}

@end

