//
//  _MiscMergeCallCommand.m
//            Written by Don Yacktman and Carl Lindberg
//        Copyright 1998 by Don Yacktman and Carl Lindberg.
//                     All rights reserved.
//      This notice may not be removed from this source code.
//
//	This header is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	

#import "_MiscMergeCallCommand.h"
#import <Foundation/NSUtilities.h>
#import <Foundation/NSArray.h>
#import "MiscMergeEngine.h"
#import "_MiscMergeProcedureCommand.h"

@implementation _MiscMergeCallCommand

- init
{
	[super init];
	argumentArray = [[NSMutableArray alloc] init];
	return self;
}

- (void)dealloc
{
	[procedureName release];
	[argumentArray release];
	[super dealloc];
}

- (BOOL)parseFromScanner:(NSScanner *)aScanner template:(MiscMergeTemplate *)template
{
	NSString *argName;

	[self eatKeyWord:@"call" fromScanner:aScanner isOptional:NO];
	procedureName = [[self getArgumentStringFromScanner:aScanner toEnd:NO] retain];

	while (argName = [self getArgumentStringFromScanner:aScanner toEnd:NO])
	{
		[argumentArray addObject:argName];
	}

	return YES;
}

- (void)executeForMerge:(MiscMergeEngine *)aMerger
{
	NSString *symbolName = [NSString stringWithFormat:@"_MiscMergeProcedure%@", procedureName];
	_MiscMergeProcedureCommand *procCommand = [[aMerger userInfo] objectForKey:symbolName];
	int i, count = [argumentArray count];
	NSMutableArray *realArgArray = [NSMutableArray arrayWithCapacity:count];

	if (procCommand == nil)
	{
		NSLog(@"%@: Error -- procedure %@ not found.", [self class], procedureName);
		return;
	}
	
	for (i=0; i<count; i++)
	{
		id value = [aMerger valueForField:[argumentArray objectAtIndex:i]];
		if (value == nil) value = @""; // good idea?
		[realArgArray addObject:value];
	}
	
	[procCommand executeForMerge:aMerger arguments:realArgArray];
}

@end

