//
//  MiscMergeTemplate.h
//            Written by Don Yacktman and Carl Lindberg
//        Copyright 1998 by Don Yacktman and Carl Lindberg.
//                     All rights reserved.
//      This notice may not be removed from this source code.
//
//	This header is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	

#import <Foundation/NSObject.h>

@class NSMutableArray, NSCharacterSet;
@class MiscMergeCommandBlock;

@interface MiscMergeTemplate : NSObject
{
	MiscMergeCommandBlock *topLevelCommands;
	NSMutableArray        *commandStack;
	char                  startDelimiter;
	char                  endDelimiter;
	NSString              *_startDelimiterString;
	NSString              *_endDelimiterString;
	NSCharacterSet        *_parseStopChars;
}

/*" Creating a MiscTemplate "*/
+ template;
+ templateWithString:(NSString *)aString;

/*" Initializing a MiscTemplate "*/
- init;
- initWithString:(NSString *)string;
- initWithContentsOfFile:(NSString *)filename;

/*" Accessing/setting the delimiters "*/
+ (char)defaultStartDelimiter;
+ (char)defaultEndDelimiter;
- (char)startDelimiter;
- (char)endDelimiter;
- (NSString *)startDelimiterString;
- (NSString *)endDelimiterString;
- (void)setStartDelimiter:(char)startDelim endDelimiter:(char)endDelim;

/*" Command block manipulation "*/
- (void)pushCommandBlock:(MiscMergeCommandBlock *)aBlock;
- (void)popCommandBlock:(MiscMergeCommandBlock *)aBlock;
- (void)popCommandBlock;
- (MiscMergeCommandBlock *)currentCommandBlock;
- (MiscMergeCommandBlock *)topLevelCommandBlock;

/*" Loading the template "*/
- (void)parseContentsOfFile:(NSString *)filename;
- (void)parseString:(NSString *)string;

/*" Deriving the class for a command string "*/
- (Class)classForCommand:(NSString *)aCommand;

@end
