

#import "MiscMergeTemplate.h"
#import "MiscMergeCommandBlock.h"
#import "MiscMergeEngine.h"
#import <Foundation/NSString.h>
#import <Foundation/NSUtilities.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSAutoreleasePool.h>

@implementation NSArray (Testing)

- (NSArray *)computeFromIndexForKey:(NSString *)key
{
	int theIndex = [key intValue];
	NSRange subRange = {theIndex, [self count] - theIndex};

	return [self subarrayWithRange:subRange];
}

/*"
 * This method allows an '@index' key to be used on NSArrays, so that a
 * particular member of an array can be accessed in a keypath.  The next
 * part of the keypath should be a numeric index.  No range checking is
 * done; if  the range is out of bounds an execption will be raised as
 * normal.
"*/
- (id)computeIndexForKey:(NSString *)aKey
{
	NSRange dotRange = [aKey rangeOfString:@"."];
	
	if (dotRange.length == 0)
	{
		return [self objectAtIndex:[aKey intValue]];
	}
	else
	{
		NSString *myKey = [aKey substringToIndex:dotRange.location];
		NSString *restOfKey = [aKey substringFromIndex:NSMaxRange(dotRange)];
		return [[self objectAtIndex:[myKey intValue]] valueForKeyPath:restOfKey];
	}
}

@end

int main(int argc, char *argv[])
{
	NSAutoreleasePool *localPool = [[NSAutoreleasePool alloc] init];
	NSString *filename = [NSString stringWithCString:argv[1]];
	MiscMergeTemplate *template = [[MiscMergeTemplate alloc] init];
	MiscMergeEngine *engine = [[MiscMergeEngine alloc] init];
	NSDictionary *dict = [@"{ foo = FOO; bar = BAR; arr = (a, b, cc); } " propertyList];

	[template setStartDelimiter:'(' endDelimiter:')'];
	[template parseContentsOfFile:filename];

//	NSLog(@"%@", [[template topLevelCommandBlock] commandArray]);

	[engine setTemplate:template];
//	[engine execute:nil];

	NSLog(@"%@", [engine executeWithObject:dict sender:nil]);

	[localPool release];
	return 0;
}
