//
//  MiscNull.m
//    Written by Carl Lindberg Copyright 1998 by Carl Lindberg.
//                     All rights reserved.
//      This notice may not be removed from this source code.
//
//	This header is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	

#import "MiscNull.h"
#import <limits.h>   // for UINT_MAX

@implementation MiscNull

+ (id)null
{
	static id theNullObject = nil;

	if (theNullObject == nil)
		theNullObject = [[super allocWithZone:NULL] init];
	return theNullObject;
}

+ allocWithZone:(NSZone *)aZone
{
	return [self null];
}

- (BOOL)isNull
{
	return YES;
}

/* Since there can be only one instance... */
- retain				{	return self;		}
- autorelease			{	return self;		}
- (void)release			{}
- (unsigned)retainCount	{	return UINT_MAX;	}

@end
