/* Generator.h created by tthomas on Tue 07-Dec-1999 */

#import <Foundation/NSObject.h>

@class NSString;
@class NSArray;
@class Declaration;
@class MiscMergeTemplate;
@class ResourceLocator;


@interface Generator : NSObject
{
    ResourceLocator* _locator;
    NSString* _inString;
    NSArray* _generatedDeclarations;
}

+ (Generator*) generatorWithInput:(NSString*)inString;
- (id) initWithInput:(NSString*)inString;

- (NSString*) inString;
- (ResourceLocator*) resourceLocator;
- (NSString*) generateOutputUsingTemplateName:(NSString*)templateName;

- (NSArray*) generatedDeclarations;
- (void) _generateDeclarationsFromInputString;

- (NSString*) _mergeUsingDeclaration:(Declaration*)aDeclaration template:(MiscMergeTemplate*)template;
- (void) _setupResourceLocator;

@end
