/* Declaration.m created by tthomas on Tue 07-Dec-1999 */

#import "NSString_CGExtension.h"
#import "Declaration.h"

@implementation Declaration

/*"
**	Declaration represents a single ivar declaration and type. An
**	example is a type of NSString and ivar named _shortname.
**	These are the instances that are passed to the MiscMergeEngine. Thus you
**	can use any instance method below in your templates.
"*/

+ (Declaration*) declarationWithType:(NSString*)type ivar:(NSString*)ivar
/*"
**	Returns a newly created autoreleased instance as long as type and ivar are
**	not nil and are not empty.
"*/
{
    return [[[self alloc] initWithType:type ivar:ivar] autorelease];
}

- (id) initWithType:(NSString*)type ivar:(NSString*)ivar
/*"
**	Returns a newly created instance as long as type and ivar are not nil
**	and are not empty.
"*/
{
    BOOL error = ((self = [super init]) == nil);

    if (!error) {
        if (type != nil && ![type isEqualToString:@""]) {
            _type = [type copy];
        }
        if (ivar != nil && ![type isEqualToString:@""]) {
            _ivar = [ivar copy];
        }

        error = (_type == nil || _ivar == nil);

        if (error) {
            [self autorelease];
        }
    }

    return error ? nil : self;
}

- (void) dealloc
{
    [_type release];
    [_ivar release];

    [super dealloc];
}

- (NSString*) type { return _type; }
- (NSString*) ivar { return _ivar; }

- (NSString*) ivarSansUnderscore
/*"
**	Returns our ivar without any underscore (if it had one to begin with).
"*/
{
    // Could be a litle smarter about this.. what if the user used two
    // underscores?
    NSString* ivarSansUnderscore = [self ivar];
    if ([ivarSansUnderscore hasPrefix:@"_"]) {
        ivarSansUnderscore = [ivarSansUnderscore substringWithRange:NSMakeRange (1, [ivarSansUnderscore length] -1)];
    }

    return ivarSansUnderscore;
}

- (NSString*) ivarSansUnderscoreCapitalized
/*"
**	If our ivar is "_name" this returns "Name". You can use this method in your
**	templates to create -set<<ivarSansUnderscoreCapitalized>>: methods.
"*/
{
    return [[self ivarSansUnderscore] firstCharacterCapitalizedString];
}

- (BOOL) isTypePrimitive
/*"
**	Returns YES if our type is not an object (and therefore needs different accessor
**	methods (at least for ObjC).
"*/
{
    BOOL isTypePrimitive = NO;
    NSString* type = [self type];
    // Probably not a complete set. Don't bother with two word types
    // like "unsigned int" because we don't even support parsing it yet.
    if ([type isEqualToString:@"int"] ||
        [type isEqualToString:@"float"] ||
        [type isEqualToString:@"char"] ||
        [type isEqualToString:@"double"] ||
        [type isEqualToString:@"BOOL"] ||
        [type isEqualToString:@"short"] ||
        [type isEqualToString:@"unsigned"]) {
        isTypePrimitive = YES;
    }

    return isTypePrimitive;
}

- (BOOL) isTypeArray
/*"
**	Returns YES if type contains the word Array in it. That should catch any use
**	of NSMutableArray, NSArray.
"*/
{
    BOOL isTypeArray = NO;
    NSString* type = [self type];
    if (([type rangeOfString:@"Array"].length) > 0) {
        isTypeArray = YES;
    }

    return isTypeArray;
}

- (NSString*) description
// For debugging purposes.
{
    return [NSString stringWithFormat:@"%@ (%@, %@)", [super description], [self type], [self ivar]];
}

@end
