static void *rcs_id = (rcs_id, "$Header: /LocalDeveloper/Source/CVS/OmniGroup/OmniCVSEOModelerBundle/CVSManager.m,v 1.1 1996/12/06 13:05:48 andrew Exp $");

/* CVSManager.m created by andrew on Wed 13-Nov-1996 */


#import <Foundation/Foundation.h>
#import <EOModeler/EOModeler.h>

#import "CVSManager.h"


/* minor extension to NSFileManager to make it more convenient to see if a directory exists */

@interface NSFileManager (CVSBundleExtensions)
- (BOOL)directoryExistsAtPath:(NSString *)path;
@end

@implementation NSFileManager (CVSBundleExtensions)
- (BOOL)directoryExistsAtPath:(NSString *)path;
{
    BOOL isDirectory;

    if (![self fileExistsAtPath: path isDirectory: &isDirectory])
        return NO;
    return isDirectory;
}

@end


/*
   On +load we register for notification when a document is saved. When we get that notification, we try to copy the CVS info from the model's backup to the newly saved model.
*/

@interface CVSManager (Private)
+ (NSString *)restoreCVSInfoToDocumentAt:(NSString *)path;
+ (void)didSaveDocument:(NSNotification *)notification;
@end


@implementation CVSManager

static NSString *versionString = @"version 1.0";

+ (NSString *)versionString;	// in case we ever decide to display this somehow
{
    return versionString;
}

+ (void)load;
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(didSaveDocument:) name:EOMDocumentDidSaveNotification object:nil];
}

+ (NSString *)restoreCVSInfoToDocumentAt:(NSString *)path;
{
    NSFileManager *manager;
    NSString *cvsPath;
    NSString *oldPath;

    manager = [NSFileManager defaultManager];

    if (![manager directoryExistsAtPath:path])
        return [NSString stringWithFormat:@"Could not find model at %@", path];

    oldPath = [path stringByAppendingString:@"~"];
    if (![manager directoryExistsAtPath:oldPath])
        return nil;	// backup won't exist if model being saved was brand new

    cvsPath = [oldPath stringByAppendingPathComponent:@"CVS"];
    if (![manager directoryExistsAtPath:cvsPath])
        return nil;	// no CVS info to copy - probably never been checked in

    path = [path stringByAppendingPathComponent:@"CVS"];
    if ([manager directoryExistsAtPath:path])
        return [NSString stringWithFormat:@"CVS directory already exists at %@", path];

    if (![manager movePath:cvsPath toPath:path handler:nil])
        return [NSString stringWithFormat:@"Failed to move '%@' to '%@'", cvsPath, path];

    return nil;
}

+ (void)didSaveDocument:(NSNotification *)notification;
{
    NSString *errorMsg;

    errorMsg = [self restoreCVSInfoToDocumentAt:[(EOModelerDocument *)[notification object] documentPath]];
    if (errorMsg)
        NSRunAlertPanel (nil, errorMsg, nil, nil, nil);
}

@end
