/*
 * Relocation types used in the m88k implementation.  Relocation entries for
 * things other than instructions use the same generic relocation as discribed
 * above and their r_type is RELOC_VANILLA.  The rest of the relocation types
 * are for instructions.  Since they are for instructions the r_address field
 * indicates the 32 bit instruction that the relocation is to be preformed on.
 * The fields r_pcrel and r_length are ignored for non-RELOC_VANILLA r_types.
 */
enum reloc_type_m88k
{
    M88K_RELOC_VANILLA,	/* generic relocation as discribed above */
    M88K_RELOC_PAIR,	/* the second relocation entry of a pair */
    M88K_RELOC_PC16,
    M88K_RELOC_PC26,
    M88K_RELOC_HI16,	/* a PAIR follows with the low half */
    M88K_RELOC_LO16,	/* a PAIR follows with the high half */
    M88K_RELOC_SECTDIFF,/* a PAIR follows with subtract symbol value */
    M88K_RELOC_PB_LA_PTR/* prebound lazy pointer */
};
