/* CONFIDENTIAL
 * Copyright (c) 1993-1996 by NeXT Software, Inc. as an unpublished work.
 * All rights reserved.
 *
 * S3_928_Modes.c -- Modes for the S3 928.
 *
 * Author:  Derek B Clegg	21 May 1993
 */
#import "S3Modes.h"

/* Tables of register values for the supported modes. */

/* S3 928 800 x 600 x 15 (S3 mode 0x114 or 0x214).
 */
static const S3Mode S3_928_800x600x15 = {
    "S3_928[800 x 600 x 15]", S3_928, TWO_MEGABYTES,

    /* Mode control. */
    { 60, 0x02 },

    /* Advanced function control register (0x4AE8). */
    0x07,

    /* Extra CRTC registers. */
    {
	0x31, 0x8D, 0x32, 0x10, 0x33, 0x20, 0x34, 0x00, 0x35, 0x00,
	0x3A, 0x95, 0x3B, 0xF8, 0x3C, 0x19, 0x40, 0x50, 0x43, 0x00,
	0x50, 0x10, 0x51, 0x50, 0x53, 0x00, 0x54, 0x00, 0x56, 0x00,
	0x57, 0x00, 0x5C, 0x32, 0x5D, 0x00, 0x5E, 0x00, 0x5F, 0x00,
	0x60, 0x2F, 0x61, 0x81, 0x62, 0x92, 0x63, 0x92,
    },

    /* Standard VGA registers. */
    {
	0xEF,
	0x00,
	{ 0x01, 0x01, 0x0F, 0x00, 0x0E },
	{
	    0x3D, 0x31, 0x32, 0x82, 0x35, 0x1D, 0x74, 0xF0, 0x00, 0x60,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0xC8, 0x58, 0x8C, 0x57, 0x00,
	    0x00, 0x57, 0x73, 0xE3, 0xFF,
	},
	{
	    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x01, 0x00, 0x0F, 0x00,
	},
	{
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF,
	},
    }
};

/* S3 928 800 x 600 x 24 (S3 mode 0x221).
 */
static const S3Mode S3_928_800x600x24 = {
    "S3_928[800 x 600 x 24]", S3_928, THREE_MEGABYTES,

    /* Mode control. */
    { 60, 0x02 },

    /* Advanced function control register (0x4AE8). */
    0x07,

    /* Extra CRTC registers. */
    {
	0x31, 0x8D, 0x32, 0x10, 0x33, 0x20, 0x34, 0x00, 0x35, 0x00,
	0x3A, 0x95, 0x3B, 0x7C, 0x3C, 0x32, 0x40, 0x50, 0x43, 0x00,
	0x50, 0x30, 0x51, 0x60, 0x53, 0x20, 0x54, 0x00, 0x56, 0x00,
	0x57, 0x00, 0x5C, 0x32, 0x5D, 0x00, 0x5E, 0x00, 0x5F, 0x00,
	0x60, 0x2F, 0x61, 0x81, 0x62, 0x92, 0x63, 0x92,
    },

    /* Standard VGA registers. */
    {
	0xEF,
	0x00,
	{ 0x01, 0x01, 0x0F, 0x00, 0x0E },
	{
	    /* I had to add the `+1' to make this mode work. */
	    0x7F, 0x63 + 1, 0x64 + 1, 0x82, 0x6A, 0x1A, 0x72, 0xF0, 0x00, 0x60,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0xC8, 0x59, 0x8D, 0x57, 0x00,
	    0x00, 0x59, 0x72, 0xE3, 0xFF,
	},
	{
	    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x01, 0x00, 0x0F, 0x00,
	},
	{
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF,
	},
    }
};

/* S3 928 1024 x 768 x 8 (S3 mode 0x205).
 */
static const S3Mode S3_928_1024x768x8 = {
    "S3_928[1024 x 768 x 8]", S3_928, ONE_MEGABYTE,

    /* Mode control. */
    { 60, 0x0D, 70, 0x0E, 72, 0x05 },

    /* Advanced function control register (0x4AE8). */
    0x07,

    /* Extra CRTC registers. */
    {
	0x31, 0x8D, 0x32, 0x10, 0x33, 0x00, 0x34, 0x00, 0x35, 0x00,
	0x3A, 0x95, 0x3B, 0x9D, 0x3C, 0x9F, 0x40, 0x51, 0x43, 0x00,
	0x50, 0x00, 0x51, 0x00, 0x53, 0x00, 0x54, 0x08, 0x56, 0x00,
	0x57, 0x00, 0x5C, 0x0D, 0x5D, 0x00, 0x5E, 0x00, 0x5F, 0x00,
	0x60, 0x1F, 0x61, 0x81, 0x62, 0x00, 0x63, 0x00,
    },

    /* Standard VGA registers. */
    {
	0x2F,
	0x00,
	{ 0x01, 0x01, 0x0F, 0x00, 0x0E },
	{
	    0xA3, 0x7F, 0x80, 0x86, 0x84, 0x95, 0x25, 0xF5, 0x00, 0x60,
	    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x87, 0xFF, 0x80,
	    0x60, 0xFF, 0x21, 0xEB, 0xFF,
	},
	{
	    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x01, 0x00, 0x0F, 0x00,
	},
	{
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF,
	},
    }
};

/* S3 928 1024 x 768 x 15 (S3 mode 0x117).
 */
static const S3Mode S3_928_1024x768x15 = {
    "S3_928[1024 x 768 x 15]", S3_928, TWO_MEGABYTES,

    /* Mode control. */
    { 60, 0x0D, 72, 0x05 },

    /* Advanced function control register (0x4AE8). */
    0x07,

    /* Extra CRTC registers. */
    {
	0x31, 0x8D, 0x32, 0x10, 0x33, 0x20, 0x34, 0x00, 0x35, 0x00,
	0x3A, 0x95, 0x3B, 0x4B, 0x3C, 0x20, 0x40, 0x50, 0x43, 0x00,
	0x50, 0x10, 0x51, 0x50, 0x53, 0x00, 0x54, 0x00, 0x56, 0x00,
	0x57, 0x00, 0x5C, 0x3D, 0x5D, 0x00, 0x5E, 0x00, 0x5F, 0x00,
	0x60, 0x2F, 0x61, 0x82, 0x62, 0x00, 0x63, 0x00,
    },

    /* Standard VGA registers. */
    {
	0xEF,
	0x00,
	{ 0x01, 0x01, 0x0F, 0x00, 0x0E },
	{
	    0x4F, 0x3F, 0x40, 0x12, 0x42, 0x0A, 0x24, 0xF5, 0x00, 0x60,
	    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x88, 0xFF, 0x00,
	    0x00, 0xFF, 0x21, 0xE3, 0xFF,
	},
	{
	    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x01, 0x00, 0x0F, 0x00,
	},
	{
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF,
	},
    }
};

/* S3 928 1024 x 768 x 24 (S3 mode 222).
 * This mode doesn't quite work yet.
 */
static const S3Mode S3_928_1024x768x24 = {
    "S3_928[1024 x 768 x 24]", S3_928, THREE_MEGABYTES,

    /* Mode control. */
    { 60, 0x0D, 72, 0x05 },

    /* Advanced function control register (0x4AE8). */
    0x07,

    /* Extra CRTC registers. */
    {
	0x31, 0x8D, 0x32, 0x10, 0x33, 0x20, 0x34, 0x00, 0x35, 0x00,
	0x3A, 0x95, 0x3B, 0x9D, 0x3C, 0x40, 0x40, 0x50, 0x43, 0x00,
	0x50, 0x30, 0x51, 0x60, 0x53, 0x20, 0x54, 0x08, 0x56, 0x00,
	0x57, 0x00, 0x5C, 0x3D, 0x5D, 0x00, 0x5E, 0x00, 0x5F, 0x00,
	0x60, 0x1F, 0x61, 0x81, 0x62, 0x00, 0x63, 0x00,
    },

    /* Standard VGA registers. */
    {
	0x2F,
	0x00,
	{ 0x01, 0x01, 0x0F, 0x00, 0x0E },
	{
	    0xA3, 0x7F, 0x80, 0x86, 0x84, 0x95, 0x25, 0xF5, 0x00, 0x60,
	    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x87, 0xFF, 0x00,
	    0x60, 0xFF, 0x21, 0xEB, 0xFF,
	},
	{
	    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x01, 0x00, 0x0F, 0x00,
	},
	{
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF,
	},
    }
};

/* S3 928 1280 x 1024 x 8 (S3 mode 0x107).
 */
static const S3Mode S3_928_1280x1024x8 = {
    "S3_928[1280 x 1024 x 8]", S3_928, TWO_MEGABYTES,

    /* Mode control. */
    { 60, 0x0C },

    /* Advanced function control register (0x4AE8). */
    0x07,

    /* Extra CRTC registers. */
    {
	0x31, 0x8D, 0x32, 0x10, 0x33, 0x20, 0x34, 0x00, 0x35, 0x00,
	0x3A, 0x95, 0x3B, 0xBB, 0x3C, 0x14, 0x40, 0x50, 0x43, 0x00,
	0x50, 0xC0, 0x51, 0x00, 0x53, 0x00, 0x54, 0x00, 0x56, 0x00,
	0x57, 0x00, 0x5C, 0x3C, 0x5D, 0x00, 0x5E, 0x55, 0x5F, 0x00,
	0x60, 0x2F, 0x61, 0x81, 0x62, 0x40, 0x63, 0x40,
    },

    /* Standard VGA registers. */
    {
	0x2F,
	0x00,
	{ 0x01, 0x01, 0x0F, 0x00, 0x0E },
	{
	    /* I had to add the `-0xE' to make this work. */
	    0x30, 0x27, 0x27, 0x94, 0x29, 0x8E - 0xE, 0x37, 0x52, 0x00, 0x60,
	    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x05, 0x8C, 0xFF, 0xA0,
	    0x00, 0x00, 0x31, 0xA3, 0xFF,
	},
	{
	    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x01, 0x00, 0x0F, 0x00,
	},
	{
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF,
	},
    }
};

/* S3 928 1280 x 1024 x 15 (S3 mode 0x21A)
 */
static const S3Mode S3_928_1280x1024x15 = {
    "S3_928[1280 x 1024 x 15]", S3_928, FOUR_MEGABYTES,

    /* Mode control. */
    { 60, 0x0C },
    
    /* Advanced function control register (0x4AE8). */
    0x07,

    /* Extra CRTC registers. */
    {
	0x31, 0x8F, 0x32, 0x10, 0x33, 0x20, 0x34, 0x00, 0x35, 0x00,
	0x3A, 0x95, 0x3B, 0x5D, 0x3C, 0x28, 0x40, 0x50, 0x43, 0x00,
	0x50, 0x10, 0x51, 0x60, 0x53, 0x20, 0x54, 0x00, 0x56, 0x00,
	0x57, 0x00, 0x5C, 0x3C, 0x5D, 0x00, 0x5E, 0x55, 0x5F, 0x00,
	0x60, 0x2F, 0x61, 0x81, 0x62, 0x40, 0x63, 0x40,
    },

    /* Standard VGA registers. */
    {
	0x2F,
	0x00,
	{ 0x01, 0x01, 0x0F, 0x00, 0x0E },
	{
	    /* I had to add the `+1' to get this to work. */
	    0x65, 0x4F + 1, 0x50 + 1, 0x89, 0x52, 0x9C, 0x37, 0x52, 0x00, 0x40,
	    0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x05, 0x8C, 0xFF, 0x00,
	    0x00, 0x00, 0x31, 0xE3, 0xFF,
	},
	{
	    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x01, 0x00, 0x0F, 0x00,
	},
	{
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF,
	},
    }
};

const IODisplayInfo S3_928_ModeTable[] = {
    {
	/* S3 928; 800 x 600 x 15 @ 60Hz. */
	800, 600, 1024, 2048, 60, 0, IO_15BitsPerPixel, 
	IO_RGBColorSpace, "-RRRRRGGGGGBBBBB", 0, (void *)&S3_928_800x600x15,
    },
    {
	/* S3 928; 800 x 600 x 24 @ 60Hz. */
	800, 600, 1024, 4096, 60, 0, IO_24BitsPerPixel, 
	IO_RGBColorSpace, "--------RRRRRRRRGGGGGGGGBBBBBBBB",
	0, (void *)&S3_928_800x600x24,
    },
    {
	/* S3 928; 1024 x 768 x 8 @ 60Hz. RGB */
	1024, 768, 1024, 1024, 60, 0, IO_8BitsPerPixel,
	IO_RGBColorSpace, "PPPPPPPP", 0, (void *)&S3_928_1024x768x8,
    },
    {
	/* S3 928; 1024 x 768 x 8 @ 70Hz. RGB */
	1024, 768, 1024, 1024, 70, 0, IO_8BitsPerPixel,
	IO_RGBColorSpace, "PPPPPPPP", 0, (void *)&S3_928_1024x768x8,
    },
    {
	/* S3 928; 1024 x 768 x 8 @ 72Hz. RGB */
	1024, 768, 1024, 1024, 72, 0, IO_8BitsPerPixel,
	IO_RGBColorSpace, "PPPPPPPP", 0, (void *)&S3_928_1024x768x8,
    },
    {
	/* S3 928; 1024 x 768 x 8 @ 60Hz. */
	1024, 768, 1024, 1024, 60, 0, IO_8BitsPerPixel,
	IO_OneIsWhiteColorSpace, "WWWWWWWW", 0, (void *)&S3_928_1024x768x8,
    },
    {
	/* S3 928; 1024 x 768 x 8 @ 70Hz. */
	1024, 768, 1024, 1024, 70, 0, IO_8BitsPerPixel,
	IO_OneIsWhiteColorSpace, "WWWWWWWW", 0, (void *)&S3_928_1024x768x8,
    },
    {
	/* S3 928; 1024 x 768 x 8 @ 72Hz. */
	1024, 768, 1024, 1024, 72, 0, IO_8BitsPerPixel,
	IO_OneIsWhiteColorSpace, "WWWWWWWW", 0, (void *)&S3_928_1024x768x8,
    },
    {
	/* S3 928; 1024 x 768 x 15 @ 60Hz. */
	1024, 768, 1024, 2048, 60, 0, IO_15BitsPerPixel,
	IO_RGBColorSpace, "-RRRRRGGGGGBBBBB", 0, (void *)&S3_928_1024x768x15,
    },
    {
	/* S3 928; 1024 x 768 x 15 @ 72Hz. */
	1024, 768, 1024, 2048, 72, 0, IO_15BitsPerPixel,
	IO_RGBColorSpace, "-RRRRRGGGGGBBBBB", 0, (void *)&S3_928_1024x768x15,
    },
    {
	/* S3 928; 1024 x 768 x 24 @ 60Hz. */
	1024, 768, 1024, 4096, 60, 0, IO_24BitsPerPixel,
	IO_RGBColorSpace, "--------RRRRRRRRGGGGGGGGBBBBBBBB",
	0, (void *)&S3_928_1024x768x24,
    },
    {
	/* S3 928; 1024 x 768 x 24 @ 72Hz. */
	1024, 768, 1024, 4096, 72, 0, IO_24BitsPerPixel,
	IO_RGBColorSpace, "--------RRRRRRRRGGGGGGGGBBBBBBBB",
	0, (void *)&S3_928_1024x768x24,
    },
    {
	/* S3 928; 1280 x 1024 x 8 @ 60Hz. */
	1280, 1024, 1280, 1280, 60, 0, IO_8BitsPerPixel,
	IO_OneIsWhiteColorSpace, "WWWWWWWW", 0, (void *)&S3_928_1280x1024x8,
    },
    {
	/* S3 928; 1280 x 1024 x 8 @ 60Hz. RGB */
	1280, 1024, 1280, 1280, 60, 0, IO_8BitsPerPixel,
	IO_RGBColorSpace, "PPPPPPPP", 0, (void *)&S3_928_1280x1024x8,
    },
    {
	/* S3 928; 1280 x 1024 x 15 @ 60Hz. */
	1280, 1024, 2048, 4096, 60, 0, IO_15BitsPerPixel,
	IO_RGBColorSpace, "-RRRRRGGGGGBBBBB", 0, (void *)&S3_928_1280x1024x15,
    },
};

const int S3_928_ModeTableCount =
	(sizeof(S3_928_ModeTable) / sizeof(S3_928_ModeTable[0]));

const int S3_928_defaultMode = 2;
