/* CONFIDENTIAL
 * Copyright (c) 1993-1996 by NeXT Software, Inc. as an unpublished work.
 * All rights reserved.
 *
 * S3_805_Modes.c -- Modes for the S3 805.
 *
 * Author:  Derek B Clegg	21 May 1993
 */
#import "S3Modes.h"

/* Tables of register values for the supported modes. */

/* S3 805 800 x 600 x 15 (S3 mode 0x114).
 */
static const S3Mode S3_805_800x600x15 = {
    "S3_805[800 x 600 x 15]", S3_805, ONE_MEGABYTE,

    /* Mode control. */
    { 60, 0x0A },

    /* Advanced function control register (0x4AE8). */
    0x03,

    /* Extra CRTC registers. */
    {
	0x31, 0x8D, 0x32, 0x10, 0x33, 0x00, 0x34, 0x00, 0x35, 0x00,
	0x3A, 0x95, 0x3B, 0xF8, 0x3C, 0x00, 0x40, 0x50, 0x43, 0x00,
	0x50, 0x90, 0x51, 0x00, 0x53, 0x00, 0x54, 0x18, 0x56, 0x00,
	0x57, 0x00, 0x5C, 0x35, 0x5D, 0x00, 0x5E, 0x00, 0x5F, 0x00,
	0x60, 0x2F, 0x61, 0x81, 0x62, 0x92, 0x63, 0x92,
    },

    /* Standard VGA registers. */
    {
	0xEF,
	0x00,
	{ 0x01, 0x01, 0x0F, 0x00, 0x0E },
	{
	    0xFC, 0xC7, 0xC7, 0x9F, 0xD3, 0x8D, 0x70, 0xF0, 0x00, 0x60,
	    0x00, 0x00, 0x00, 0x00, 0x00, 0xC8, 0x58, 0x8C, 0x57, 0xC8,
	    0x00, 0x58, 0x6F, 0xA3, 0xFF,
	},
	{
	    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x01, 0x00, 0x0F, 0x00,
	},
	{
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF,
	},
    }
};

/* S3 805 1024 x 768 x 8 (S3 mode 0x205).
 */
static const S3Mode S3_805_1024x768x8 = {
    "S3_805[1024 x 768 x 8]", S3_805, ONE_MEGABYTE,

    /* Mode control. */
    { 60, 0x0D, 70, 0x0E, 72, 0x05 },
    
    /* Advanced function control register (0x4AE8). */
    0x07,	/* 0x4AE8 */

    /* Extra CRTC registers. */
    {
	0x31, 0x8D, 0x32, 0x10, 0x33, 0x00, 0x34, 0x00, 0x35, 0x00,
	0x3A, 0x95, 0x3B, 0x9D, 0x3C, 0x9F, 0x40, 0x51, 0x43, 0x00,
	0x50, 0x00, 0x51, 0x00, 0x53, 0x00, 0x54, 0x48, 0x56, 0x00,
	0x57, 0x00, 0x5C, 0x3D, 0x5D, 0x00, 0x5E, 0x00, 0x5F, 0x00,
	0x60, 0x2F, 0x61, 0x81, 0x62, 0x00, 0x63, 0x00,
    },

    /* Standard VGA registers. */
    {
	0x2F,
	0x00,
	{ 0x01, 0x01, 0x0F, 0x00, 0x0E },
	{
	    0xA3, 0x7F, 0x80, 0x86, 0x84, 0x95, 0x25, 0xF5, 0x00, 0x60,
	    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x87, 0xFF, 0x80,
	    0x60, 0xFF, 0x21, 0xEB, 0xFF,
	},
	{
	    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39,
	    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x01, 0x00, 0x0F, 0x00,
	},
	{
	    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF,
	},
    }
};

const IODisplayInfo S3_805_ModeTable[] = {
    {
	/* S3 805; 800 x 600 x 15 @ 60Hz. */
	800, 600, 800, 1600, 60, 0, IO_15BitsPerPixel,
	IO_RGBColorSpace, "-RRRRRGGGGGBBBBB", 0, (void *)&S3_805_800x600x15,
    },
    {
	/* S3 805; 1024 x 768 x 8 @ 60Hz. */
	1024, 768, 1024, 1024, 60, 0, IO_8BitsPerPixel,
	IO_RGBColorSpace, "PPPPPPPP", 0, (void *)&S3_805_1024x768x8,
    },
    {
	/* S3 805; 1024 x 768 x 8 @ 70Hz. */
	1024, 768, 1024, 1024, 70, 0, IO_8BitsPerPixel,
	IO_RGBColorSpace, "PPPPPPPP", 0, (void *)&S3_805_1024x768x8,
    },
    {
	/* S3 805; 1024 x 768 x 8 @ 72Hz. */
	1024, 768, 1024, 1024, 72, 0, IO_8BitsPerPixel,
	IO_RGBColorSpace, "PPPPPPPP", 0, (void *)&S3_805_1024x768x8,
    },
    {
	/* S3 805; 1024 x 768 x 8 @ 60Hz. */
	1024, 768, 1024, 1024, 60, 0, IO_8BitsPerPixel,
	IO_OneIsWhiteColorSpace, "WWWWWWWW", 0, (void *)&S3_805_1024x768x8,
    },
    {
	/* S3 805; 1024 x 768 x 8 @ 70Hz. */
	1024, 768, 1024, 1024, 70, 0, IO_8BitsPerPixel,
	IO_OneIsWhiteColorSpace, "WWWWWWWW", 0, (void *)&S3_805_1024x768x8,
    },
    {
	/* S3 805; 1024 x 768 x 8 @ 72Hz. */
	1024, 768, 1024, 1024, 72, 0, IO_8BitsPerPixel,
	IO_OneIsWhiteColorSpace, "WWWWWWWW", 0, (void *)&S3_805_1024x768x8,
    },
};

const int S3_805_ModeTableCount =
	(sizeof(S3_805_ModeTable) / sizeof(S3_805_ModeTable[0]));

const int S3_805_defaultMode = 0;
