/* 
 * Copyright (c) 1993-1996 NeXT Software, Inc.  All rights reserved. 
 */

#import <driverkit/IOAudio.h>

@interface ProAudioSpectrum16 : IOAudio
+ (BOOL) probe: deviceDescription;
- (BOOL) reset;

- (BOOL) startDMAForChannel: (unsigned int) localChannel
                       read: (BOOL) isRead
                     buffer: (IOEISADMABuffer) buffer
    bufferSizeForInterrupts: (unsigned int) division;

- (void) stopDMAForChannel: (unsigned int) localChannel read: (BOOL) isRead;

- (void) interruptOccurredForInput: (BOOL *) serviceInput
                         forOutput: (BOOL *) serviceOutput;
- (void) timeoutOccurred;

- (BOOL) acceptsContinuousSamplingRates;

- (void) getSamplingRatesLow: (int *) lowRate
                       high: (int *) highRate;

- (void) getSamplingRates: (int *) rates
                   count: (unsigned int *) numRates;

- (void) getDataEncodings: (NXSoundParameterTag *) encodings
                   count: (unsigned int *) numEncodings;

- (unsigned int) channelCountLimit;

- (void)disableAllInterrupts;
- (IOReturn) enableAllInterrupts;

- (void) updateLoudnessEnhanced;
- (void) updateInputGainLeft;
- (void) updateInputGainRight;
- (void) updateOutputMute;
- (void) updateOutputAttenuationLeft;
- (void) updateOutputAttenuationRight;

@end
