//
//  _MiscMergeIncludeCommand.m
//            Written by Don Yacktman and Carl Lindberg
//        Copyright 1998 by Don Yacktman and Carl Lindberg.
//                     All rights reserved.
//      This notice may not be removed from this source code.
//
//	This header is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"License.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	

#import "_MiscMergeIncludeCommand.h"
#import <Foundation/NSString.h>
#import <Foundation/NSUtilities.h>
#import "MiscMergeTemplate.h"
#import "MiscMergeCommandBlock.h"
#import "MiscMergeEngine.h"

@implementation _MiscMergeIncludeCommand

- (void)dealloc
{
	[commandBlock release];
	[super dealloc];
}

- (BOOL)parseFromScanner:(NSScanner *)aScanner template:(MiscMergeTemplate *)template
{
	NSString *filename;
	NSString *fileString = nil;
	
	[self eatKeyWord:@"include" fromScanner:aScanner isOptional:NO];
	filename = [self getArgumentStringFromScanner:aScanner toEnd:YES];
	
	if ([filename length] > 0)
		fileString = [[NSString alloc] initWithContentsOfFile:filename];
	
	if (fileString)
	{
		MiscMergeTemplate *newTemplate = [[[template class] alloc] init];
        [newTemplate setStartDelimiter:[template startDelimiter]
                          endDelimiter:[template endDelimiter]];
        [newTemplate setFilename:filename];
        [newTemplate parseString:fileString];
		commandBlock = [[newTemplate topLevelCommandBlock] retain];
		[newTemplate release];
	}
	else
	{
        [template reportParseError:@"%@: Could not load from file '%@'", [self class], filename];
	}
	
	return YES;
}

- (void)executeForMerge:(MiscMergeEngine *)aMerger
{
	if (commandBlock)
		[aMerger executeCommandBlock:commandBlock];
}

@end

