/* EOTemplateGenerator.h created by mgentry on Mon 14-Jun-1999 */

#import <Foundation/Foundation.h>

@class EOEntity;

@interface EOTemplateGenerator : NSObject
{
    // Templates - the primary class
    NSString *mainHeaderTemplate;
    NSString *mainSourceTemplate;
    // Templates - the secondary (sub)class
    NSString *stubHeaderTemplate;
    NSString *stubSourceTemplate;
    // Templates - Java only has two
    NSString *mainJavaTemplate;
    NSString *stubJavaTemplate;

    NSMutableArray *searchPaths;
	NSMutableArray *entityNames;
	NSMutableArray *models;
    NSMutableDictionary *userVariables;

    NSString *destination;
    NSString *subclassDestination;
    BOOL      javaMode;
    BOOL      verboseMode;
}

- init;
- (void)displayHelpAndExit:(int)exitStatus;
- (void)processCommandLineArguments;
- (void)addDefaultSearchPaths;

- (void)generate;
- (void)generateEntity:(EOEntity *)entity;
- (void)generateEntity:(EOEntity *)entity
        withTemplate:(NSString *)templateName
        asPrimary:(BOOL)primary
        extension:(NSString *)fileExtension;

@end
