/* EOAccessAdditions.h created by lindberg on Mon 20-Dec-1999 */

#import <EOAccess/EOModel.h>
#import <EOAccess/EOEntity.h>
#import <EOAccess/EORelationship.h>

/* EOAccess extension methods for use by templates */

@interface EOEntity (EOGenerator)

- (BOOL)hasParentEntity;
- (NSString *)frameworkName;

- (NSString *)objcImportString;
- (NSString *)objcImportStringInRelationToEntity:(EOEntity *)sourceEntity;
- (NSString *)parentObjCImportString;

//uniqued array of relationships' -objcImportString
- (NSArray *)referencedObjCImportStrings;
- (NSArray *)arrayWithParentObjCImportStringIfNeeded;

@end

@interface EOModel (EOGenerator)

// Tries to find the framework name. First looks to see if a value for
// "EOGeneratorFrameworkName" exists in the model's -userInfo dictionary, and if
// not, looks at the model's -path to find the framework the .eomodeld is in.
// Both PB.project files and path components ending in ".framework" are looked
// for, so it should work for .eomodels insided installed frameworks or in a
// development tree. If the framework name could not be found, returns nil.
- (NSString *)frameworkName;

@end

@interface EORelationship (EOGenerator)

// If the destination entity is in an external framework, returns
// <Framework/ClassName.h>, otherwise returns "ClassName.h".
- (NSString *)objcImportString;

@end

