/* This file is part of the Project Athena Zephyr Notification System.
 * It contains source for the ZPending function.
 *
 *	Created by:	Robert French
 *
 *	$Source: /CVSRoot/CoreOS/Services/zephyr/zephyr/lib/zephyr/ZPending.c,v $
 *	$Author: wsanchez $
 *
 *	Copyright (c) 1987 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */
/* $Header: /CVSRoot/CoreOS/Services/zephyr/zephyr/lib/zephyr/ZPending.c,v 1.1.1.1 1997/08/22 22:19:17 wsanchez Exp $ */

#ifndef lint
static char rcsid_ZPending_c[] = "$Header: /CVSRoot/CoreOS/Services/zephyr/zephyr/lib/zephyr/ZPending.c,v 1.1.1.1 1997/08/22 22:19:17 wsanchez Exp $";
#endif

#include <internal.h>

int ZPending()
{
	int retval;
	
	if (ZGetFD() < 0) {
		errno = ZERR_NOPORT;
		return (-1);
	}
	
	if ((retval = Z_ReadEnqueue()) != ZERR_NONE) {
		errno = retval;
		return (-1);
	} 
	
	return(ZQLength());
}
