/**
 * Zephyr Message Viewer
 **
 * Wilfredo Sanchez | wsanchez@apple.com
 * Copyright 1998 Apple Computer, Inc.
 * All rights reserved.
 **
 * This protocol defines the interface required of a Message Viewer. A viewer
 * is responsible for accepting messages as a delegate of ZephyrClient and
 * displaying them to the user.
 **/

#import <Foundation/NSObject.h>

@class ZephyrMessage;

@protocol ZephyrViewer <NSObject>

- (void) dispatchMessage: (ZephyrMessage*) aMessage;

@end
