/**
 * Zephyr Application
 **
 * Wilfredo Sanchez | wsanchez@apple.com
 * Copyright 1998 Apple Computer, Inc.
 * All rights reserved.
 **/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#import "ZephyrClient.h"
#import "ZephyrMessage.h"
#import "NewMessageController.h"
#import "MessageBrowser.h"
#import "Extensions.h"

#import "ZephyrApplication.h"

@implementation ZephyrApplication

/********************
 * Instance Methods *
 ********************/

////
// Inits
////

- (id) init
{
    if ((self = [super init]))
      {
        /**
         * myViewer is a MessageBrowser here, but can be any other interface.
         * Ideally, the user should be able to select in a preferences panel from
         * a list of interfaces for displaying messages. For example, it might be
         * interesting to implement a viewer which operates like the X windows
         * windowgram client, to make those users feel more at home. You can do
         * that my implementing a class which draws such windowgrams. The only
         * requirement is that the class provide the dispatchMessage: method to
         * handle incoming messages.
         **/
        myViewer = [[MessageBrowser alloc] init];

        if (! myViewer)
            [NSPanel runAlertPanelWithName: @"Zephyr"
                                   message: @"ERROR: Failed to initialize message viewer."];
      }
    return self;
}

- (void) dealloc
{
    [myViewer release];

    [super dealloc];
}

////
// Actions
////

- (void) composeMessage { [self composeReplyToMessage: nil]; }

- (void) composeReplyToMessage: (ZephyrMessage*) aMessage
{
#ifdef DEBUG
    NewMessageController* aControl = [[NewMessageController alloc] initWithMessage: aMessage];

    if (! aControl)
        [NSPanel runAlertPanelWithName: @"Zephyr"
                               message: @"ERROR: Failed to initialize message composition window."];
#else
    NSLog(@"New message unimplemented.");
#endif
}

- (void) locateUsers
{
    NSLog(@"Locate users unimplemented.");
}

////
// IB Targets
////

- (void) openAboutBox: (id) aSender
{
    // Load interface
    if (! [NSBundle loadNibNamed:@"AboutBox" owner:self])
        NSLog(@"Failed to open MessageBrowser interface.");

    // Verify that the interface loaded properly
    if (! aboutBoxWindow) NSLog(@"About Box interface failed to load properly.");

    // Init window
    [aboutBoxWindow setTitle: @"About Zephyr"];
    [aboutBoxWindow makeKeyAndOrderFront: self];
}

////
// NSApplication delegate methods
////

- (void) finishLaunching
{
    [super finishLaunching];

    [NSApplication detachDrawingThread: @selector(runMessageLoop:)
                              toTarget: [ZephyrClient class]
                            withObject: myViewer];
}

@end
