/**
 * Zephyr Application
 **
 * Wilfredo Sanchez | wsanchez@apple.com
 * Copyright 1998 Apple Computer, Inc.
 * All rights reserved.
 **/

#import <AppKit/NSApplication.h>

#import "ZephyrViewer.h"

@class ZephyrMessage;

@interface ZephyrApplication : NSApplication

/**********************
 * Instance Variables *
 **********************/

{
@private
    id <ZephyrViewer> myViewer;

    ////
    // IB Outlets
    ////
#ifdef _IB_
    id aboutBoxWindow;
#else
    NSWindow* aboutBoxWindow;
#endif
}

/********************
 * Instance Methods *
 ********************/

////
// Inits
////

- (id) init;

////
// Actions
////

- (void) composeMessage;
- (void) composeReplyToMessage: (ZephyrMessage*) aMessage;
- (void) locateUsers;

////
// IB Targets
////

- (void) openAboutBox: (id) sender;

@end
