/**
 * Zephyr Message Browser
 **
 * Wilfredo Sanchez | wsanchez@apple.com
 * Copyright 1998 Apple Computer, Inc.
 * All rights reserved.
 **/

#import <Foundation/NSObject.h>

@class NSAttributedString;
@class NSMutableArray;
@class NSMutableDictionary;
@class NSWindow;
@class NSBrowser;
@class NSMatrix;
@class NSScrollView;
@class NSTextView;
@class ZephyrMessage;

#import "ZephyrViewer.h"

@interface MessageBrowser : NSObject <ZephyrViewer>

/**********************
 * Instance Variables *
 **********************/

{
@private
    NSMutableDictionary* myClassesDict;
    NSMutableDictionary* myInstancesDict;
    NSMutableDictionary* myMessageDict;
    NSMutableArray*      myMessageList;

    // Mutex
    NSLock* myEventLock;

    // Preferences
    BOOL myAggregateMessagesOption;
    BOOL myAutoUnhideOption;
    BOOL myAutoBringToFrontOption;
    BOOL myAutoCleanupOption;

    ////
    // IB Outlets
    ////
#ifdef _IB_
    id window;
    id classBrowser;
    id messageListMatrix;
    id messageView;
    id cleanupClassesButton;
    id locateButton;
    id previousMessageButton;
    id nextMessageButton;
    id deleteMessageButton;
    id composeMessageButton;
    id authenticButton;
    id encryptedButton;
#else
    NSWindow*     window;
    NSBrowser*    classBrowser;
    NSMatrix*     messageListMatrix;
    NSTextView*   messageView;
    NSButton*     cleanupClassesButton;
    NSButton*     locateButton;
    NSButton*     previousMessageButton;
    NSButton*     nextMessageButton;
    NSButton*     deleteMessageButton;
    NSButton*     composeMessageButton;
    NSButton*     authenticButton;
    NSButton*     encryptedButton;
#endif
}

/********************
 * Instance Methods *
 ********************/

////
// Inits
////

- (id) init;

////
// Accessors
////

- (NSString*     ) selectedClass;
- (NSString*     ) selectedInstance;
- (ZephyrMessage*) selectedMessage;
- (NSArray*      ) selectedMessages;

- (void) setMessageList: (NSMutableArray*) aList;

////
// Actions
////

- (void) selectInstance: (NSString*) anInstance
                ofClass: (NSString*) aClass;

- (void) selectNextMessage: (int) aDelta;

- (void) showClasses;
- (void) showMessageList;
- (void) showSelectedMessage;

- (void) deleteSelectedMessages;
- (void) cleanupClasses;

- (void) deleteMessage   : (ZephyrMessage*) aMessage;
- (void) dispatchMessage : (ZephyrMessage*) aMessage;

- (void) composeMessage;
- (void) locateUsers;

////
// IB Targets
////

#ifdef _IB_
- (void) selectClassTarget     : (id) sender;
- (void) cleanupClassesTarget  : (id) sender;
- (void) selectMessageTarget   : (id) sender;
- (void) nextMessageTarget     : (id) sender;
- (void) previousMessageTarget : (id) sender;
- (void) deleteMessageTarget   : (id) sender;
- (void) composeMessageTarget  : (id) sender;
- (void) locateUsersTarget     : (id) sender;
#endif

@end
