/**
 * Foundation and AppKit extensions
 **
 * Wilfredo Sanchez | wsanchez@apple.com
 * Copyright 1998 Apple Computer, Inc.
 * All rights reserved.
 **/

/************
 * NSString *
 ************/

#import <Foundation/NSString.h>

@interface NSMutableString (Substitution)

- (void) replaceSubstring: (NSString*   ) aSubstring
               withString: (NSString*   ) aString
                 globally: (BOOL        ) aGlobally;
- (void) replaceSubstring: (NSString*   ) aSubstring
               withString: (NSString*   ) aString
                 globally: (BOOL        ) aGlobally
                  options: (unsigned int) anOptions;

- (void) deleteSubstring: (NSString*   ) aSubstring
                globally: (BOOL        ) aGlobally;
- (void) deleteSubstring: (NSString*   ) aSubstring
                globally: (BOOL        ) aGlobally
                 options: (unsigned int) anOptions;

@end

/***********
 * NSArray *
 ***********/

#import <Foundation/NSArray.h>

@interface NSArray (Filter)

- (NSArray*) subarrayUsingSelector: (SEL) aFilter;

@end

/***********
 * NSPanel *
 ***********/

#import <AppKit/NSPanel.h>

@class NSString;

@interface NSPanel (Alert)

+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage;

+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage
           defaultButtonString: (NSString*) aDefaultButtonString;

+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage
           defaultButtonString: (NSString*) aDefaultButtonString
         alternateButtonString: (NSString*) anAlternateButtonString;

+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage
           defaultButtonString: (NSString*) aDefaultButtonString
         alternateButtonString: (NSString*) anAlternateButtonString
             otherButtonString: (NSString*) anOtherButtonString;

@end
