/* InterfaceStyle.h created by stephane on Wed 18-Feb-1998 */

/*	InterfaceStyle.preference is a bundle for Preferences.app, on RDR2.
 *	It adds the possibility to set the default look of the applications
 *	on RDR2 by using the NSInterfaceStyle API
 *
 *	Copyright (C) 1998  Stephane Corthesy
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#import "Layout.h"

@interface InterfaceStyle : Layout
{
	IBOutlet NSPanel		*panel;
    IBOutlet NSPopUpButton	*elementListPopup;
    IBOutlet NSMatrix		*styleMatrix;
    IBOutlet NSTextField	*descriptionTextField;
    IBOutlet NSButtonCell	*setButtonCell;
    IBOutlet NSButtonCell	*revertButtonCell;
    NSMutableArray			*styles;
    IBOutlet NSImageView	*warningImageView;
    IBOutlet NSTextField	*warningTextField;
}

- (IBAction) selectElementFromList:(id)sender;
- (IBAction) selectStyle:(id)sender;
- (IBAction) resetAll:(id)sender;
- (IBAction) setStyles:(id)sender;
- (IBAction) revertStyles:(id)sender;

@end
