/*
    File:       QResourceTypesEnumerator.m

    Contains:   An enumerator that returns all the resources types
                in a resource file.

    Written by: Quinn "The Eskimo!"

    Created:    Mon 19-May-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import "QResourceTypesEnumerator.h"

#import "QResourceObject.h"
#import "QResourceFile.h"

@implementation QResourceTypesEnumerator

- (id)initWithResourceFile:(QResourceFile*)aResFile
    // See comments in interface part.
{
    self = [super init];
    
    if (self != nil) {

        NSAssert( aResFile != nil, @"Cannot create a QResourceTypesEnumerator without a resource file");

        resFile = aResFile;

        typeIndex = 0;

        numResourceTypes = [resFile shortAtOffset:[resFile resourceTypeListOffset] ] + 1;

        NSAssert(numResourceTypes >= 0, @"A negative number of resource types was encountered");
    }
    
    return (self);
}

- (id)init
    // Call through to the designated initialiser.
    // In the non-subclassed case, we violate the pre-condition of the
    // designated initialiser by passing in a nil path pointer.
    // We do this because a) it's the right thing to do (see the book
    // "Object-Oriented Programming and the Objective-C Language" for
    // the reasoning), and b) a subclasser may want to subclass us in a
    // weird way.
{
    return ( [self initWithResourceFile:nil] );
}

- (QResourceObject *)nextObject
    // See comments in interface part.
{
    QResourceObject *result = nil;
    QResourceType resType;

    if ( typeIndex < numResourceTypes ) {
        
        resType = [resFile longAtOffset:[resFile resourceTypeListOffset] + 2 + 8 * typeIndex];
        
        result = [ [ [QResourceObject alloc] initWithResourceType:resType ] autorelease ];

        typeIndex += 1;
    }

    return (result);
}

@end
