/*
    File:       QPStringAdditions.m

    Contains:   Additions to NSString for initialising with Mac OS Pascal strings.

    Written by: Quinn "The Eskimo!"

    Created:    Wed 21-May-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import "QPStringAdditions.h"

@implementation NSString (QPStringAddition)

+ (id)stringWithPString:(StringPtr)pString
    // See comments in interface part.
{
    return [[NSString alloc] initWithPString:pString];
}

- (id)initWithPString:(StringPtr)pString
    // See comments in interface part.
{
    #define UseMacOSStringEncoding 1
    #if UseMacOSStringEncoding
        return [self initWithData:[NSData dataWithBytes:pString + 1 length:*pString]
                        encoding:NSMacOSRomanStringEncoding];
    #else
        return [self initWithCString:(char *) pString + 1 length:*pString];
    #endif
}

@end
